function [Parel,Palarm] = meqetcv(G,Ia)
% [Parel,Palarm] = meqetcv(Ia,G)
% Implements coil equation constraints for TCV
% Parel: Relative violation of protection equation
% Palarm: Boolean signalling violation
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% TCV case only for now
Ieq = (G.Ceq*Ia);
Ioh2(G.Seq~=1,:) = 1;
Ioh2(G.Seq==1,:) = Ia(contains(G.dima,'OH_002'));
Iprot = Ieq.*Ioh2;
Parel = zeros(size(Iprot));
ip = Iprot>=0;
Parel( ip) = Iprot( ip)./G.Ihig( ip);
Parel(~ip) = Iprot(~ip)./G.Ilow(~ip);

Palarm = (Iprot > G.Ihig | Iprot < G.Ilow);

end
