function LY = meqcat(LY,varargin)
% MEQCAT concatenate MEQ data structures
%
% LY = meqcat(LY,LY2[,LY3])
% Concatenates LY structures appending LY2 after LY.
% Multiple LY structures can be concatenated at the same time by passing
% more arguments.
%
% See also MEQIK
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

for ii=1:numel(varargin)
  LYii = varargin{ii};
  if ~(isempty(LYii) || (isstruct(LYii) && isfield(LYii,'t')))
    error('meqcat:inputStruct','inputs to meqcat must be structures with a "t" field');
  end
  if isempty(LYii) || isempty(LYii.t)
    continue; % empty slice, don't cat
  end
  k = numel(LY.t)+1; % insert after last one
  LY = meqik(LY,k,LYii);
end

end
