/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"

lapack_int FLT_LAPACKE(sysv)(int matrix_layout, char uplo, lapack_int n, lapack_int nrhs, FLT *a, 
                             lapack_int lda, lapack_int *ipiv, FLT *b, lapack_int ldb)
{
 ptrdiff_t n_, nrhs_, lda_, ldb_;
 ptrdiff_t info;
 ptrdiff_t lwork = -1;
 ptrdiff_t *ipiv_;
 FLT *work;
 FLT work_query;
 n_ = n; nrhs_ = nrhs; lda_ = lda; ldb_ = ldb;
 /* Do not use provided pointer for ipiv which is of type int * and 
 * not compatible with the expected types for SYTRF and SYSV.
 * This bit is quite bad, but needed for now in order to maintain compatibility
 * with other BLAS/LAPACKE alternatives */
 ipiv_ = (ptrdiff_t *) malloc(sizeof *ipiv_ * n_);
 /* Query optimal work array size */
 FLT_LAPACK(sytrf)(&uplo, &n_, a, &lda_, ipiv_, &work_query, &lwork, &info);
 if (info < 0) return (lapack_int) info-1;
 lwork = (lapack_int) work_query;
 work = (FLT *) malloc(sizeof *work * lwork);
 if (work == NULL) return -1;
 /* Actual call */
 FLT_LAPACK(sysv)(&uplo, &n_, &nrhs_, a, &lda_, ipiv_, b, &ldb_, work, &lwork, &info);
 free(work);
 free(ipiv_);
 return (lapack_int) (info<0 ? info-1 : info);
}
