/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"

void FLT_CBLAS(syrk)(const CBLAS_LAYOUT Layout, const CBLAS_UPLO uplo, const CBLAS_TRANSPOSE trans, 
                     const int n, const int k, const FLT alpha, const FLT *a, const int lda,
                     const FLT beta, FLT *c, const int ldc)
{
 ptrdiff_t n_, k_, lda_, ldc_;
 char * up = uplo == CblasUpper ? "U" : "L";
 char * tr = trans == CblasNoTrans ? "N" : (trans == CblasTrans ? "T" : "C");
 n_ = n; k_ = k; lda_ = lda; ldc_ = ldc;
 FLT_BLAS(syrk)(up, tr, &n_, &k_, &alpha, a, &lda_, &beta, c, &ldc_);
}
