/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"

void FLT_CBLAS(spmv)(const CBLAS_LAYOUT Layout, const CBLAS_UPLO uplo, 
                     const int n, const FLT alpha, const FLT *ap,
                     const FLT *x, const int incx, const FLT beta, FLT *y, const int incy)
{
 ptrdiff_t n_, incx_, incy_;
 char * up = uplo == CblasUpper ? "U" : "L";
 n_ = n; incx_ = incx; incy_ = incy;
 FLT_BLAS(spmv)(up, &n_, &alpha, ap, x, &incx_, &beta, y, &incy_);
}
