/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"

lapack_int FLT_LAPACKE(pptrs)(int matrix_layout, char uplo, lapack_int n, lapack_int nrhs, const FLT *ap,
                              FLT *b, lapack_int ldb)
{
 ptrdiff_t n_, nrhs_, ldb_;
 ptrdiff_t info;
 n_ = n; nrhs_ = nrhs; ldb_=ldb;
 FLT_LAPACK(pptrs)(&uplo, &n_, &nrhs_, ap, b, &ldb_, &info);
 return (lapack_int) (info<0 ? info-1 : info);
}
