/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"
void FLT_CBLAS(gemv)(const CBLAS_LAYOUT Layout, const CBLAS_TRANSPOSE trans, 
                     const int m, const int n, const FLT alpha, const FLT *a, const int lda,
                     const FLT *x, const int incx, const FLT beta, FLT *y, const int incy)
{
 ptrdiff_t m_, n_, lda_, incx_, incy_;
 char * tr = trans == CblasNoTrans ? "N" : (trans == CblasTrans ? "T" : "C");
 m_ = m; n_ = n; lda_ = lda; incx_ = incx; incy_ = incy;
 FLT_BLAS(gemv)(tr, &m_, &n_, &alpha, a, &lda_, x, &incx_, &beta, y, &incy_);
}
