/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meqh.h"

void FLT_CBLAS(gemm)(const CBLAS_LAYOUT Layout, const CBLAS_TRANSPOSE transa, const CBLAS_TRANSPOSE transb, 
                     const int m, const int n, const int k, const FLT alpha, const FLT *a, const int lda,
                     const FLT *b, const int ldb, const FLT beta, FLT *c, const int ldc)
{
 ptrdiff_t m_, n_, k_, lda_, ldb_, ldc_;
 char * ta = transa == CblasNoTrans ? "N" : (transa == CblasTrans ? "T" : "C");
 char * tb = transb == CblasNoTrans ? "N" : (transb == CblasTrans ? "T" : "C");; 
 m_ = m; n_ = n; k_ = k; lda_ = lda; ldb_ = ldb; ldc_ = ldc;
 FLT_BLAS(gemm)(ta, tb, &m_, &n_, &k_, &alpha, a, &lda_, b, &ldb_, &beta, c, &ldc_);
}
