%LOCRMEX  Location of q surfaces
% [AR] = LOCRMEX(AQ,QQ,QR,NAR,NF) returns the location of the flux surfaces where
% QR=QQ(AQ==AR)
%
% AQ: x data
% QQ: y data
% QR: Requested y values
% NAR: (optional) Number of maximum R values to be found (per QR) for nonmonotonic profiles.
%          (default=1: outermost value found)
% NF: (optional) AR = NF signals the q value was not found
%
% AR: interpolated x data
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function aR = locRmex(aQ,qQ,qR,varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 aR = locRmexm(aQ,qQ,qR,varargin{:});
 
end
