%LIUZ0  LIUQE vertical stabilisation function based on ZA-Z0
% DZ = LIUZ0(P,RST,Z0,ZA) returns the stabilising vertical shift fedback on
% ZA-Z0 with PID gains P.stab*[1 P.stabint P.stabder] and
% Z0=Z0-P.stabcint*DZ.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function dz = liuz0(P,rst,z0,zA,~)
 persistent K S Z0
 if nargin
  if rst
   K = P.stab*[1 P.stabint P.stabder]; % PID gains
   S = [0 ; 0; zA-z0];                 % PID states
   Z0 = z0;
  end
  S = (zA - Z0) + [0 ; S(2) ; -S(1)];  % update states
  dz = K*S;
  Z0 = Z0 - dz*P.stabcint;
 else
  dz = false;
 end
end
