%LIUXRFX  RFX LIUQE diagnostic measurements
% LX = LIUXRFX(EQUIL,T,L) returns a structure with diagnostic measurements
% at time T for EQUIL. See also LIUX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function X = liuxrfx(t,L)
 
 A = load(['LIUXRFX_' int2str(L.P.shot)]); A = A.X;
 nt = numel(t);
 
 X.shot = L.P.shot;
 X.t    = t;
 % X.Ff   =  resamp(A.Ff,A.tt,t)';
 % X.Uf   = -resamp(A.Uf,A.tt,t)';
 % X.Bm   =  resamp(A.Bm,A.tt,t)';
 % X.Ia   =  resamp(A.Ia,A.tt,t)';
 % X.Ft   =  zeros(1,nt);
 % X.RBt  =  zeros(1,nt);
 % X.Ip   =  resamp(A.It,A.tt,t)';
 
 X.Ff   =  interp1(A.tt,A.Ff,t)';
 X.Uf   = -interp1(A.tt,A.Uf,t)';
 X.Bm   =  interp1(A.tt,A.Bm,t)';
 X.Ia   =  interp1(A.tt,A.Ia,t)';
 X.Ft   =  zeros(1,nt);
 X.rBt  =  zeros(1,nt);
 X.Ip   =  interp1(A.tt,A.It,t)';
 
end
