%LIUXCOMP LIUQE measurement signal comparison
% h = liuxcomp(LX1,plotopts1,LX2,plotopts2,labels);
% 
% EXAMPLE
%   shot = 57587; % (or 70392)
%   [~,LX1] = liuqe(shot,[0:1e-3:2]); % get standard inputs
%   [~,LX2] = liuqe(shot,[0:1e-3:2],'xrtc',1); % get inputs for SCD data
%   liuxcomp(LX1,LX2,{'mag','rtc'});
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function hs = liuxcomp(LX1,LX2,labels)
if nargin==2
  labels={'LX1','LX2'};
end
assert(numel(labels)==2,'labels must have two entries');

fieldstoplot = {'Ff','Bm','Ia','Xt','rBt','Iu','Ip'};

hf = gcf; clf(hf); figure(hf);
nr = numel(fieldstoplot); hs = gobjects(nr,1);
for ii=1:nr
  hs(ii) = subplot(nr,1,ii);
  if ii==nr; xlabel(hs(ii),'t [s]'); end
  hold(hs(ii),'on')
  title(hs(ii),fieldstoplot{ii});
end

for ifield = 1:numel(fieldstoplot)
  myfield = fieldstoplot{ifield};
  ax1 = hs(ifield,1);
  
  % plot values
  for ii=1:2
    switch ii
      case 1, LXi = LX1; sty = '-';  
      case 2, LXi = LX2; sty = '--';
    end
    if isfield(LXi,myfield) && ~isempty(LXi.(myfield))
      plot(ax1,LXi.t,LXi.(myfield),'linestyle',sty,'color',ax1.ColorOrder(ii,:));
    else
      warning(' does not contain field %s or field is empty',myfield);
    end
  end
 
end

linkaxes(hs,'x');
hleg = legend(hs(end),labels); set(hleg,'orient','hor','box','off','location','best')
end
