function X = liuxana(shot,t,L)
% LIUXANA - Input data for ANAMAK
% run FBT to get liuqe input data for anamak
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

fields_to_rm = {'iterq','algoNL','fastcoil','Ipmin','cde','argout',...
  'jacobian_handle','jacobian_sparse','algoGMRES','userowmask',...
  'mkryl','usepreconditioner','itert'};
P = rmfield(L.P,fields_to_rm(isfield(L.P,fields_to_rm)));
PP = [fieldnames(P),struct2cell(P)]';          % pass L parameters as fbt inputs
[Lb,~,LYb] = fbt('ana',shot,[],PP{:});         % input time is arbitrary for fbtana (one equilibrium)

assert(~isempty(LYb),'fbt did not converge for anamak shot %d',shot)
if isempty(t), t=LYb.t; end

% Adjust time base
LYb = meqinterp(LYb,t,'nearest');
LYb.t = t;
X = meqxconvert(Lb,LYb,L,true); % Return minimal LX
end
