%LIUWTCV   Write LIUQE specific data in TCV tree
% LIUWTCV(SHOT,TREE,BRANCH,L,LY,DEP) writes LIUQE specific data from LY in
% TCV SHOT TREE BRANCH. L contains ancillary data as obtained by LIUP.
% DEP is the list of node paths to be written in NODES_USED
% subnodes (used in TCV to automatically rerun LIUQE) To
% be used with MEQWTCV. See also MEQWTCV,LIUP,LIUT.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function liuwtcv(shot,tree,branch,~,LY,dep)
 
 %% Checks
 assert(isequal(numel(LY.t),numel(unique(LY.t))),'LY.t has some repeated values, this run cannot be stored in MDS');
 
 %%
 
 meqmdsopen(shot,tree,branch)
 
 v = meqver(); % Get meq version number
 
 put = @(node,x,f,d,u,h) meqput(node,x,f,d,u,h,v,dep);
 
 %% Algorithm outputs
 put('DELTA_Z'     ,LY.dz   ,'f',{          'TIME_FAST'},'m'    ,'Residual vertical shift (t)[m]')
 
end
