function LY = liutsim(L,LX,varargin)
%LIUTSIM  Equivalent function to liut.m to run liutsim.slx from existing L,LX
% liutsim.slx has 2 referenced subsystems;
% liuxslx.slx outputs the LX bus object (from LX data in its data dictionary)
% liutslx.slx is the time stepper that receives LX and outputs LY.
% Data dictionaries are automatically created, linked and deleted as necessary
% see also LIUSIMC
% Custom parameters:
% .bslvdprec    flag for real precision in block solver
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

for k = 1:2:length(varargin)
  L.P.(varargin{k}) = varargin{k+1};
end

[L] = liusimc(L,LX); % consolidate for Simulink use

liusmodel = 'liusim';

%% Simulate model
out = sim(liusmodel);

%% Convert timeseries results to LY
LY = ts2meq(L,out.LY);
LY.t = LX.t; % Restore original time

% Custom post-processing (missing fields, ...)
LY = liusimpost(L,LY);

%% Close without saving
close_system(liusmodel,0);
close_system('liutslx.slx',0);
close_system('liuxslx.slx',0);

%% Plot for debug
if L.P.debug
  for it = 1:nt
    meqplott(L,meqxk(LY,it));
    drawnow;
  end
end
end
