% LIUPANA  ANAMAK LIUQE configuration parameters
% P = LIUPANA(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters for SHOT, optionally replacing or adding parameters with
% specified values. See also LIUP.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function P = liupana(shot,varargin)
 
 P = meqpana(shot); % default anamak parameters
 % default parameters
 P.Bmerr        = 1e-3;
 P.Iaerr        = 100;
 P.Iuerr        = 100;
 P.Iperr        = 1e3;
 P.debug        = 0;
 P.elomin       = Inf;
 P.shot         = shot;
 P.ivesm        = 1; 
 P.selu         = 'v';
 P.fetype       = 'tri'; % Triangular elements fit circular/ellipsoidal limiter better
 
 % overwrites
 for k = 1:2:length(varargin)
  P.(varargin{k}) = varargin{k+1};
 end

 % for LIUQE, need to know nu early to define weights
 if ~isfield(P,'nu')
   switch P.selu
     case {'s','v','e'}, P.nu = P.nv;
     case 'n', P.nu = 0;
     otherwise, error('untreated case');
   end
 end
 

end
