function Ppairs = liup_doublet(varargin)
% Return default parameters  for liu inputs as {'Name', Value} format for multiple domain case. 
% Overload eventual extra parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

P = struct();
P.nelem = 12; % #FE for initialization in liut
P.iters = 0;
P.zup = NaN;
P.zlp = NaN;
P.rop = NaN;
P.rip = NaN;
P.ndom = 3; % Maximum number of domains allowed. 
P.bfct = @bfabmex;
P.bfp =  [0 1];
% Warning! size(P.wCo) = [ng*nD]. Needs to provide consistent bfp, bfct, ndom, wCo
P.wCo = [0;0;Inf]; % Exact constraint in Co for 0 current in the mantle. 
P.wdz = [0;0;Inf];
P.idoublet = 1;
P.fetype = 'bil';
P.idml = 0;
P.izgrid= true;
P.Ipmin= 1e4;
P.Iperr =  50;
P.Iaerr =  400;
P.Iuerr =  2000;
P.icsint = true;
P.ilim = 3;

%% Overwrite defaults with inputs
for k = 1:2:numel(varargin)
  P.(varargin{k}) = varargin{k+1};
end

%% Convert struct to pairs {'Name',Value} to be passed as inputs to liu
Ppairs=[fieldnames(P).'; struct2cell(P).'];
Ppairs=Ppairs(:).';

end

