function G = liugtcv(shot,P)
%LIUGTCV  TCV LIUQE geometry and electromagnetic parameters
% LIUGTCV(SHOT,P) returns a structure with geometry and electromagnetic
% parameters for TCV SHOT. See also MEQGTCV,LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Flux loop selection
self = 'F';

P.shot = shot;
xargs = {'Bms','Rs','Brxa','Brxu'};
G = meqgtcv(P,P.sela,38,128,1:38,1:38,P.selx,P.selu,P.selc,xargs{:});

%% dz-stabilization scheme
if ~isempty(P.selx)
 meqmdsopen(P.static,'STATIC',[],P.mdsserver);
 if strcmp(self,'F1')
  G.dzMfx =            -mdsdata('STATIC("DMUTDZI_"//$1//"_"//$2)[$3,*]',self,P.selx,G.dimf);
 else
  G.dzMfx = -2*pi*G.rf.*mdsdata('STATIC(     "BR_"//$1//"_"//$2)[$3,*]',self,P.selx,G.dimf);
 end
  
 G.dzBmx  =  cos(G.am).*mdsdata('STATIC(         "DBRDZ_M_"//$1)[$2,*]',     P.selx,G.dimm) + ...
             sin(G.am).*mdsdata('STATIC(         "DBZDZ_M_"//$1)[$2,*]',     P.selx,G.dimm);
end

%% DML
if P.idml
 meqmdsopen(shot,'TCV_SHOT',[],P.mdsserver);
 % DML plasma current coupling
 k = find(strcmp('FIX-PLA-LIN',deblank(mdsdata('GETNCI("\\RESULTS::DML:BO0%%.PARAM:TYPE","RECORD")'))));
 if ~isempty(k) && strcmp(P.selx,'X')
  mdsstr = sprintf('\\RESULTS::DML:BO%03d:C',k);
  [dd,status] = mdsdata(mdsstr);
  assert(isodd(status),'Error loading %s for shot %d',mdsstr,shot);
  G.Mtx = reshape(dd,numel(G.rx),numel(G.zx))'/((G.rx(2)-G.rx(1))*(G.zx(2)-G.zx(1)));
 end
end

%% Plasma current estimator: Ip = Ipm*Bm + Ipa*Ia + Ipu*Iu
%    Use same selection as Bm measurements
mask = P.wBm(1:38)>0;
rm = G.rm(mask);
zm = G.zm(mask);
Ipm = sqrt(diff(rm([end,1:end])).^2 + diff(zm([end,1:end])).^2)';
Ipm = (Ipm+Ipm([2:end 1]))/(2*mu0);
G.Ipm = zeros(1,38);
G.Ipm(mask) = Ipm;
 
