%LIUGRFX  RFX LIUQE geometry and electromagnetic parameters
% LIUGRFX(~,P) returns a structure with geometry for RFX. See also LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function G = liugrfx(~,P)
 
 A = load('LIUGRFX'); A = A.G;
 
 % Vessel
 G.rv = A.rv; G.zv = A.zv;
 G.Rv = A.Rv;
 
 Yvv = diag(1./G.Rv); % coil resistances in parallel
 Tsv = A.Tvs';
 G.Tvs = Yvv * Tsv' / (Tsv * Yvv * Tsv');
 G.Rs  = diag(G.Tvs' * diag(G.Rv) * G.Tvs);
 
 % Active coil turns
 G.rw  = A.rw; G.zw = A.zw;
 G.Twa = A.Twa;
 
 % Tile apperture (limiter)
 G.rl = A.rl; G.zl = A.zl;
 
 % Magnetics
 G.rm = A.rm; G.zm = A.zm; G.am = A.am;
 G.rf = A.rf; G.zf = A.zf;
 
 G = liug(P,G); % compute derived quantities
 
 return
