%LIUGANA  ANA LIUQE geometry and electromagnetic parameters
% LIUGANA(~,P) returns a structure with geometry for ANA. See also LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function G = liugana(~,P)

G = meqgana(P);

%% Plasma current estimator: Ip = Ipm*Bm + Ipa*Ia + Ipu*Iu
% Similar to TCV
[~,im] = sort(unwrap(atan2(G.zm,G.rm - P.r0)),'descend'); % Order them clockwise in (R,Z) 
G.Ipm = sqrt(diff(G.rm(im([end,1:end]))).^2 + diff(G.zm(im([end,1:end]))).^2).';
G.Ipm = -(G.Ipm+G.Ipm([2:end 1]))/(2*mu0); % Minus sign because probe orientation (G.am) is going counter-clockwise

return
