%LIUG  LIUQE geometry and electromagnetic parameters
% G = LIUG(G,P) defines missing fields in the structure G using parameters
% in structure P. See also MEQG.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function G = liug(G,P,xargs)

if nargin<3, xargs={}; end % default
xargs = [xargs,{'Brxa','Brxu','Mby','dzMfx','dzBmx'}];

G = meqg(G,P,xargs{:});

% Other liuqe-specific defaults
if ~isfield(G,'Mtx')
  G.Mtx = zeros(numel(G.zx),numel(G.rx));
end
if ~isfield(G,'rW')
  G.dimW = {};
  [G.aW,G.rW,G.zW,G.oW] = deal([]);
end
if ~isfield(G,'Ipm')
  G.Ipm = zeros(0,G.nm);
end
if ~isfield(G,'Bms')
  G.Bms = zeros(G.nm,0);
end

end
