%LIUDZ  LIUQE vertical stabilisation function based on shift fitting
% DZ = ZF(P,RST,~,~,DZG) returns the stabilising vertical shift fedback on DZG
% with PI gains P.stab and P.stabint.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function dz = liudz(P,rst,~,~,dzg)
 persistent zdzg
 if nargin
  if rst
   zdzg = 0;
  end
  dz = P.stab*dzg + P.stabint*zdzg;
  zdzg = zdzg + dzg;
 else
  dz = true;
 end
end
