function liucomp(L1,LY1,L2,LY2,labels)
%LIUCOMP  compare two LIUQE time evolutions sharing same time base
% liucomp(L1,LY1,L2,LY2,labels)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

assert(all(LY1.t==LY2.t),'LY1,LY2 must have same time base')

%% compute Ip(psi)
Ipl1 = abs(LY1.Q3Q./LY1.Q1Q/4e-7/pi/4/pi^2); Ipl1(end,:) = abs(LY1.Ip);
Ipl2 = abs(LY2.Q3Q./LY2.Q1Q/4e-7/pi/4/pi^2); Ipl2(end,:) = abs(LY2.Ip);

%% generate plot
figure(1); clf;
h(1) = subplot(131);
h(2) = subplot(332);
h(3) = subplot(333);
h(4) = subplot(335);
h(5) = subplot(336);
h(6) = subplot(338);
h(7) = subplot(339);

ax = h(6);
i951 = iround(L1.pQ.^2,0.95); i952 = iround(L2.pQ.^2,0.95);
plot(ax,LY1.t,abs(1./LY1.iqQ(1,:)),'b',LY2.t,abs(1./LY2.iqQ(1,:)),'r',...
        LY1.t,abs(1./LY1.iqQ(i951,:)),'b--',LY2.t,abs(1./LY2.iqQ(i952,:)),'r--'); 
    title(ax,'q_0, q_{95}')
ax = h(7);
plot(ax,LY1.t,LY1.PQ(1,:)/1e3,'b',LY2.t,LY2.PQ(1,:)/1e3,'r'); 
title(ax,'p(0) [kA]')

for it = 1:numel(LY1.t)
    ax = h(1);
    fQ = linspace(0,1,11);% fQ = L1.pQ.^2;
    contour(ax,L1.G.rx,L1.G.zx,LY1.Fx(:,:,it),fQ*(LY1.FB(it)-LY1.FA(it))+LY1.FA(it),'b');
    set(ax,'xlim',L.bh([1,3]),'ylim',L.bh([2,4]))
    hold(ax,'on');axis(ax,'equal');
    contour(ax,L2.G.rx,L2.G.zx,LY2.Fx(:,:,it),fQ*(LY2.FB(it)-LY2.FA(it))+LY2.FA(it),'r');
    hold(ax,'off');
    if (nargin>4 && it==1)
        legend(ax,labels,'location','southoutside');
    end
    title(ax,sprintf('t=%1.3fs Ip1=%2.1fkA, Ip2=%2.1fkA',[LY1.t(it),LY1.Ip(it)/1e3,LY2.Ip(it)/1e3]));
    
    ax = h(2);
    plot(ax,L1.pQ.^2,1./abs(LY1.iqQ(:,it)),'b',L2.pQ.^2,1./abs(LY2.iqQ(:,it)),'r');
    title(ax,'q')
    
    ax = h(3);
    plot(ax,L1.pQ.^2,abs(LY1.PQ(:,it))/1e3,'b',L2.pQ.^2,LY2.PQ(:,it)/1e3,'r');
    title(ax,'P [kPa]')
    
    ax = h(4);
    plot(ax,L1.pQ.^2,abs(LY1.TQ(:,it)),'b',L2.pQ.^2,abs(LY2.TQ(:,it)),'r');
    title(ax,'T [Wb]')
    
    ax = h(5);
    plot(ax,L1.pQ.^2,abs(Ipl1(:,it))/1e3,'b',L2.pQ.^2,abs(Ipl2(:,it))/1e3,'r');
    title(ax,'Ipl [kA]')
    drawnow

end

return