function LY = liuNLmeas(L,LX,LY,Iy,ag,F0,F1,rA,rB,nA,nB,ITpDg,IyD,Ie,dz,...
  dojac,picardJac,xHasIy, ...
  Fx,zA,zB,dr2FA,dz2FA,drzFA,dr2FX,dz2FX,drzFX,ixI,dF0dFx,dF1dFx,...
  assign_LXIy,Opy,Tyg,dITygdF0,dITygdF1)
% LIUNLMEAS LIU non-linear measurement evaluation and jacobians
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

iue = [L.ind.iua,L.ind.iuu];

% DML measurement
if L.P.idml
  % Synthetic value
  dXtdag = sum(ITpDg,1).*L.fTg.'*2e-7/LX.rBt;
  dXtdIy = L.Mty;
  LY.Xt = dXtdag*ag + dXtdIy*Iy(:);

  if dojac
    % Jacobian components
    if ~picardJac && ~assign_LXIy
      dXtdITpDg = reshape(repmat(L.fTg.*ag,1,L.nD).',1,L.ng*L.nD)*2e-7/LX.rBt;
      [~,~,~,dITpDgdFx] = meqbfct1Jac(L,nB,Opy, Tyg   ,dITygdF0,dITygdF1,dF0dFx,dF1dFx);
      dXtdFx = dXtdITpDg*dITpDgdFx;
    else
      dXtdFx = zeros(1,L.nx);
    end

    % Assemble jacobian
    LY.dXtdx = zeros(1,L.nN );
    LY.dXtdu = zeros(1,L.nuN);
    if xHasIy && ~picardJac
      LY.dXtdx(L.ind.ixGS) = dXtdFx*L.Mxy + dXtdIy;
      LY.dXtdu(      iue ) = dXtdFx*L.Mxe;
    elseif ~picardJac
      LY.dXtdx(L.ind.ixGS) = dXtdFx - (dXtdIy./L.rhsf.')*L.dlst;
      LY.dXtdu(      iue ) = 0;
    elseif xHasIy
      LY.dXtdx(L.ind.ixGS) = dXtdIy;
      LY.dXtdu(      iue ) = 0;
    else
      LY.dXtdx(L.ind.ixGS) = - (dXtdIy./L.rhsf.')*L.dlst;
      LY.dXtdu(      iue ) = 0;
    end
    LY.dXtdx(L.ind.ixg) = dXtdag;
    % Apply state scaling
    LY.dXtdx = LY.dXtdx.*L.xscal.';
  end
end

% Regularization constraints
if any(L.Wq)
  % Get r0 using old method, valid up to L.nD=3
  r0 = ones(L.nD,1);
  r0(   1:nA) = rA;
  r0(nA+1:nB) = rB(1:nB-nA);
  ir0 = 1./r0;
  % Synthetic value
  [Qqg,Xq0] = L.bfct(6,L.bfp,[],F0,F1,r0,ir0,L.idsx);
  LY.Xq = Qqg*ag - Xq0;

  if dojac
    % Jacobian components
    dXqdag = Qqg;
    if ~picardJac
      [dQqgdF0,dQqgdF1,dQqgdr0,dQqgdir0] = L.bfct(16,L.bfp,[],F0,F1,r0,ir0,L.idsx);
      % Derivatives of r0
      d = 1;
      if L.P.icsint
        rI = r0(1:nB);
        zI = [zA;zB(1:nB-nA)];
        % FIXME
        dz2FI = [dz2FA;dz2FX(1:nB-nA)];
        dr2FI = [dr2FA;dr2FX(1:nB-nA)];
        drzFI = [drzFA;drzFX(1:nB-nA)];
        [ ~, ~, drIdFx] = asxycsJac(Fx,zI,rI,dz2FI,dr2FI,drzFI,L,d);
      else
        [ ~, ~, drIdFx] = asxyJac(Fx,L.dzx,L.drx,L.idzx,L.idrx,ixI(1:nB),d);
      end
      dr0dFx = [drIdFx;zeros(L.nD-nB,L.nx)];
      % dXqdFx
      dXqdF0 =  reshape(sum(dQqgdF0.*ag.',2),L.nq,L.nD);
      dXqdF1 =  reshape(sum(dQqgdF1.*ag.',2),L.nq,L.nD);
      dXqdr0 = (reshape(sum(dQqgdr0.*ag.',2),L.nq,L.nD) + ...
        reshape(sum(dQqgdir0.*ag.',2),L.nq,L.nD).*(-ir0.*ir0).');
      dXqdFx = dXqdF0*dF0dFx + dXqdF1*dF1dFx + dXqdr0*dr0dFx;
    end

    % Assemble jacobian
    LY.dXqdx = zeros(L.nq,L.nN );
    LY.dXqdu = zeros(L.nq,L.nuN);
    if xHasIy && ~picardJac
      LY.dXqdx(:,L.ind.ixGS) = dXqdFx*L.Mxy;
      LY.dXqdu(:,      iue ) = dXqdFx*L.Mxe;
    elseif ~picardJac
      LY.dXqdx(:,L.ind.ixGS) = dXqdFx;
    end
    LY.dXqdx(:,L.ind.ixg) = dXqdag;
    % Apply state scaling
    LY.dXqdx = LY.dXqdx.*L.xscal.';
  end
end

% Inequality constraints
if L.P.ipm && L.nc
  % Synthetic value
  [Qcg,Xc0] = L.bfct(7,L.bfp,[],F0,F1);
  LY.Xc = Qcg*ag - Xc0;

  if dojac
    % Jacobian components
    dXcdag = Qcg;
    if ~picardJac
      [dQcgdF0,dQcgdF1] = L.bfct(17,L.bfp,[],F0,F1);
      % dXcdFx
      dXcdF0 =  reshape(sum(dQcgdF0.*ag.',2),L.nc,L.nD);
      dXcdF1 =  reshape(sum(dQcgdF1.*ag.',2),L.nc,L.nD);
      dXcdFx = dXcdF0*dF0dFx + dXcdF1*dF1dFx;
    end

    % Assemble jacobian
    LY.dXcdx = zeros(L.nc,L.nN );
    LY.dXcdu = zeros(L.nc,L.nuN);
    if xHasIy && ~picardJac
      LY.dXcdx(:,L.ind.ixGS) = dXcdFx*L.Mxy;
      LY.dXcdu(:,      iue ) = dXcdFx*L.Mxe;
    elseif ~picardJac
      LY.dXcdx(:,L.ind.ixGS) = dXcdFx;
      LY.dXcdu(:,      iue ) = 0;
    end
    LY.dXcdx(:,L.ind.ixg) = dXcdag;
    % Apply state scaling
    LY.dXcdx = LY.dXcdx.*L.xscal.';
  end
end

% Vertical stabilization parameter
if L.ndz
  % Synthetic value
  % IyD computed when dz passed via aux (algoNL=all-nl only)
  dXrddz = L.Mdzry*reshape(IyD,L.ny,L.nD);
  LY.Xr = L.Mry*Iy(:) + L.Mre*Ie + dXrddz*dz;

  if dojac
    % Assemble jacobian
    LY.dXrddz = dXrddz;
  end
end

end
