/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "vblas.h"
/* These functions are defined in MKL, not in CBLAS */


/* Element-wise inversion */
void vdInv(const int n, const double *a, double *y){
    for(int i=n; i--;) *y++ = 1./(*a++);
}

void vsInv(int n, const float *a, float *y){
    for(int i=n; i--;) *y++ = 1./(*a++);
};

/* Addition */
void vsAdd(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)+(*b++);
};

void vdAdd(const int n, const double *a, const double *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)+(*b++);
};

/* Subtraction */
void vsSub(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)-(*b++);
};

void vdSub(const int n, const double *a, const double *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)-(*b++);
};

/* Multiplication */
void vsMul(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)*(*b++);
};

void vdMul(const int n, const double *a, const double  *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)*(*b++);
};

/* Division */
void vsDiv(const int n, const float *a, const float  *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)/(*b++);
};

void vdDiv(const int n, const double *a, const double  *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)/(*b++);
};
