/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
/* function [Wpol,Ft0,Vp] = vizr(Fx,Opy,ry,iry,rBt,drx,dzx,nrx,nzx) */
void FLT_NAME(vizr)(FLT *y1, FLT *y2, FLT *y3, FLT *f, int8_t *O, FLT*r, FLT *ir, FLT rBt, 
                    FLT dr, FLT dz, int nr, int nz) {
 int i,j;
 int ni;
 FLT xr,xz,
     yr, yz, yp = 0.0, yi = 0.0, yv = 0.0,
     drdz = dr/dz, dzdr = dz/dr, ds = dr*dz,
     *f1 = f+1, *f2 = f+nz, *f3 = f2+2, *f4 = f2+(nz+1);
 for (j=nr-2;j--;) {
  yr = 0;
  yz = 0;
  ni = 0; // counter of how many grid points on this R are in the plasma domain
  for (i=nz-2;i--;) {
   if (*O++) {
    xr = *f4 - *f1;
    xz = *f3 - *f2;
    yr += xr * xr;
    yz += xz * xz;
    ni++;
   }
   f1++; f2++; f3++; f4++;
  }
  xr = *ir++; xz = *r++;
  yp += (yr*dzdr + yz*drdz) * xr;
  yi += ni * xr;
  yv += ni * xz;
  f1 += 2; f2 += 2; f3 += 2; f4 += 2;
 }
 /* Assign outputs */
 *y1 = 15831.43494411528*yp; /* 1/(16*pi*mu0) */
 *y2 = rBt*ds*yi;
 *y3 = 6.283185307179586*ds*yv;  /* Volume = 2pi\int RdRdZ = 2*pi*sum(ni*Ri)*dr*dz */
}