/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

/* Y = [A*B C*D] */
void FLT_NAME(resp)(FLT *Y, FLT*A, FLT *B, FLT*C, FLT *D, int m, int nA, int nB, int nC, int nD) {
 FLT_CBLAS(gemm)(CblasColMajor, CblasNoTrans, CblasNoTrans, m, nB, nA, FLTC(1.0), A, m, B, nA, FLTC(0.0), Y     , m);
 FLT_CBLAS(gemm)(CblasColMajor, CblasNoTrans, CblasNoTrans, m, nD, nC, FLTC(1.0), C, m, D, nC, FLTC(0.0), Y+m*nB, m);
}
