/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void FLT_NAME(pdom)(meq_bool *Opy, FLT *Fx, FLT FB, FLT Ip, meq_bool *OXy, int nzy, int nry) {
 meq_bool *pOpy = Opy, *pOXy = OXy;
 FLT  *pFx = Fx + nzy + 3;
 int i,j;
 if (Ip > 0.0)
  for (i = nry; i--; pFx += 2)
   for (j = nzy; j--;)
    *pOpy++ = *pOXy++ & (*pFx++ > FB);
 else
  for (i = nry; i--; pFx += 2)
   for (j = nzy; j--;)
    *pOpy++ = *pOXy++ & (*pFx++ < FB);
}
