/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void FLT_NAME(nfdb)(FLT *dnf, FLT *f, int nx, int ny, int ntot)
{
  int i, k, nx2=nx-2, nx3=nx-3, nx5=nx-5, ny2=ny-2;
  FLT *f1, *f2;
  for (k = 0; k < ntot; k++) {
    f2 = (f1 = f+nx+1) + nx;
    for (i=nx2; i--;) {
      *dnf++ = *f1++ * FLTC(4.0) - *f2++;
    }
    f1 = f+nx+1; f2 = f1+1;
    for (i=ny2; i--; ) {
      *dnf++ = *f1 * FLTC(4.0) - *f2;
      f1 += nx3; f2 += nx5;
      *dnf++ = *f1 * FLTC(4.0) - *f2;
      f1 += 3; f2 += 5;
    }
    f2 = (f1 = f+ny2*nx+1) - nx;
    for (i=nx2; i--;) {
      *dnf++ = *f1++ * FLTC(4.0) - *f2++;
    }
    f += nx*ny;
  }
}
