/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

/* [Ie,aj,st] = ipmj(uAjj,Aje,Aej,Ie0,aj0,Ie_,aj_,Qcj,Xc,s,z,tol,iters) */
void FLT_NAME(ipmj)(FLT *Ie, FLT *aj, meq_bool *st, FLT *uAjj, FLT *Aje, FLT *Aej, FLT *Ie0, FLT *aj0, FLT *Ie_,
                    FLT *aj_, FLT *Qcj, FLT *Xc, FLT *s, FLT *z, FLT tol, int iters, FLT *w, int nj, int ne, int nc)
{
 FLT *aj1=w, *aj2=aj1+nj, *w1=aj2+nj; /* w size  nj*(nj+1)/2+4*nj+6*nc */
 FLT t,t0;
 int k,kit;
 int kt; /* dummy for kt return from ipm2 */

 /* Ie = Ie_; */
 COPY(ne,Ie,Ie_);
 /* aj1 = aj_; */
 COPY(nj,aj1,aj_);
 /* for kit=iters:-1:1 */
 for (kit=iters; kit--;) {
  /* aj2 = aj0 + Aje*Ie; */
  COPY(nj,aj2,aj0);
  GEMV(aj2,Aje,Ie,nj,ne);
  /* [aj,s,z,~,st] = ipm2mex(uAjj,aj2,Qcj,Xc,aj1,s,z,tol,iterj,false); */
  FLT_NAME(ipm2)(aj,s,z,&kt,st,uAjj,aj2,Qcj,Xc,aj1,s,z,tol*1e6,1,meq_false,w1,nj,nc);
  /* Ie = Ie0 + Aej*aj; */
  COPY(ne,Ie,Ie0);
  GEMV(Ie,Aej,aj,ne,nj);
  /* if norm(aj-aj1,Inf) < tol, break, end */
  t = FLTC(0.0);
  for (k=nj; k--;) {
   t0 = ABS(aj[k]-aj1[k]);
   if (t0 > t) t = t0;
  }
  *st = *st && (t < tol);
  if (*st) break;
  /* aj1 = aj; */
  COPY(nj,aj1,aj);
 }
}
