/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

/*  [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ,ItQ,LpQ,rbQ,Q5Q] = fsgi(M1q,M2q,rq,irq,rA,FA,FB,BA,lX,rB,iTQ,idoq) */
void FLT_NAME(fsgi)(FLT *Q0Q, FLT *Q1Q, FLT *Q2Q, FLT *Q3Q, FLT *Q4Q, FLT *iqQ,
                    FLT *ItQ, FLT *LpQ, FLT *rbQ, FLT *Q5Q, FLT *SlQ,
                    FLT *M1q, FLT *M2q, FLT *rq, FLT*irq,
                    FLT rA, FLT FA, FLT FB, FLT BA, meq_bool lX, FLT rB, FLT *iTQ,
                    FLT idoq, int npq, int noq) {
 int i, j;
 FLT *pQ0Q = Q0Q, *pQ1Q = Q1Q, *pQ2Q = Q2Q, *pQ3Q = Q3Q, *pQ4Q = Q4Q, *piqQ = iqQ,
     *pItQ = ItQ, *pLpQ = LpQ, *prbQ = rbQ, *pQ5Q = Q5Q, *pSlQ = SlQ,
     *pM1q = M1q, *pM2q = M2q, *prq = rq, *pirq = irq, *piTQ = iTQ, vM1q, vM2q, vM3q, vrq, virq;
 FLT s0, s1, s2, s3, s4, s5, s6;
 FLT irA = rA ? FLTC(1.0) / rA : FLTC(0.0),
     irB,
     FAB4 = FLTC(4.0) * (FA - FB),
     CA = HIPI * BA,
     Cq = FAB4 * idoq,
     C1 = HIPI * Cq,
     C3 = FAB4 * FAB4,
     C5 = HIPI * ABS(FAB4),
     CL = INV(idoq),
     CS = TWOPI*CL,
     CI = FAB4*IMU0/FLTC(noq); /* (doq)/(2*pi*mu0) */
 /* axis */
 *pQ0Q++ = irA;
 *pQ1Q++ = HIPI * CA * irA;
 *pQ2Q++ = irA * irA;
 *pQ3Q++ = FLTC(0.0);
 *pQ4Q++ = FLTC(0.0);
 *piqQ++ = CA * rA * *piTQ++;
 *pItQ++ = FLTC(0.0);
 *prbQ++ = rA;
 *pLpQ++ = FLTC(0.0);
 *pQ5Q++ = FLTC(0.0);
 *pSlQ++ = FLTC(0.0);
 
 for (j = npq; j--; ) {
  
  /* theta integrals */
  s0 = s1 = s2 = s3 = s4 = s5 = s6 = 0.0;
  for (i = noq; i--; ) {
   vM1q = *pM1q++;
   vM2q = *pM2q++;
   vM3q = sqrt(vM2q*vM1q);
   vrq  = *prq++ ;
   virq = *pirq++;
   s0 += vM1q       ; /* sum(M1q     ) */       
   s1 += vM1q * vrq ; /* sum(M1q.* rq) */
   s2 += vM1q * virq; /* sum(M1q.*irq) */
   s3 += vM2q * virq; /* sum(M2q.*irq) */
   s4 += vM2q * vrq ; /* sum(M2q.* rq) */
   s5 += vM3q       ; /* sum(M3q     ) */
   s6 += vM3q * vrq ; /* sum(M3q.* rq) */
  }
  s1 = 1.0 / s1;
  
  *pQ0Q++ =      s1 * s0     ;
  *pQ1Q++ = C1 * s1          ;
  *pQ2Q++ =      s1 * s2     ;
  *pQ3Q++ = C3 * s1 * s3     ;
  *pQ4Q++ = C3 * s1 * s4     ;
  *piqQ++ = Cq / s2 * *piTQ++;
  *pItQ++ = CI      * s3     ;
  *pQ5Q++ = C5 * s1 * s6     ;
  *prbQ++ =      s6 / s5     ;
  *pLpQ++ = CL * s5          ;
  *pSlQ++ = CS * s6          ;
 }

 /* X point */
 if (lX) {
  irB = rB ? FLTC(1.0) / rB : FLTC(0.0);
  *(--pQ0Q) = irB;
  *(--pQ1Q) = FLTC(0.0);
  *(--pQ2Q) = irB * irB;
  *(--pQ3Q) = FLTC(0.0);
  *(--pQ4Q) = FLTC(0.0);
  *(--piqQ) = FLTC(0.0);
  *(--pQ5Q) = FLTC(0.0);
 }
}
