/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

/*  [VQ,AQ] = fsg2(aq,rA,crq,doq) */
void FLT_NAME(fsg2)(FLT *VQ, FLT *AQ, FLT *aq, FLT rA,
                    FLT *crq, FLT doq, int npq, int noq) {
 int i, j;
 FLT *pVQ = VQ, *pAQ = AQ, *paq = aq, *pcrq;
 FLT vaq,qaq;
 FLT s1, s2, s3;
 FLT C1 = 0.5*doq, C2 = TWOPI*doq;
 /* axis */
 *pVQ++  = FLTC(0.0);
 *pAQ++  = FLTC(0.0);

 for (j = npq; j--; ) {
  pcrq = crq;

  /* theta integrals */
  s1 = s2 = s3 = 0.0;
  for (i = noq; i--; ) {
   vaq = (*paq++);
   qaq = vaq*vaq;
   s1 += qaq * (0.5*rA + ITHREE * vaq * (*pcrq++));
   s2 += qaq;
  }

  *pVQ++  = C2 * s1;
  *pAQ++  = C1 * s2;
 }
}
