/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
# define TEST if ((df1*df2 > FLTC(0.0)) | ((df1-df2)*fn > FLTC(0.0))) *fl = fn;

void FLT_NAME(fl4p)(FLT *fl, FLT *drfl, FLT *dzfl,
  FLT *f, int *k, FLT *c, FLT fn, int nl, int nz) {
 int l;
 FLT f0, df1, df2, *fl0 = fl, *c0 = c;
 int *k0 = k;
 /* Interpolate flux on limiter points */
 FLT_NAME(bint)(fl, f, k, c, nl, nz);
 if (fn != FLTC(0.0)) {
  /* Discard non-extremum points */
  fl = fl0;
  f0 = *fl;
  df1 = f0 - fl[nl-1];
  df2 = fl[1] - f0;
  for (l=nl-2; l--; ) {
   TEST; fl++;
   df1 = df2;
   df2 = fl[1] - *fl;
  }
  TEST; fl++;
  df1 = df2;
  df2 = f0 - *fl;
  TEST;
  /* Compute derivatives in R and Z direction */
  fl = fl0; /* Restore pointers to     */
  k  = k0;  /*                         */
  c  = c0;  /* their initial locations */
  for (l=0; l < nl; l++, k++, c+=4, fl++) {
   if (*fl != fn) {
    drfl[l] = (f[(*k)+nz  ] - f[(*k)     ])*(c[1]+c[0]) +
              (f[(*k)+nz+1] - f[(*k)+1   ])*(c[3]+c[2]);
    dzfl[l] = (f[(*k)+1   ] - f[(*k)     ])*(c[3]+c[0]) +
              (f[(*k)+nz+1] - f[(*k)+nz  ])*(c[2]+c[1]);
   }
  }
 }
}
