/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void FLT_NAME(bfpr)(FLT *IgNg, FLT *gNg, int n) {
 int i, n1=n-1;
 if (n == 0) return;
 FLT d=FLTC(-0.5)/n1, x;
 IgNg += n1; gNg += n1;
 FLT *Ig1=IgNg+n, *Ig2=Ig1+n,
      *g1= gNg+n,  *g2= g1+n;
 *IgNg = *Ig1 = *Ig2 = FLTC(0.0);
 for (i=n1; i--; gNg--, g1--, g2--) {
  x = *IgNg + (*gNg + *(gNg-1)) * d;
  *(--IgNg) = x;
  x = *Ig1 + (*g1 + *(g1-1)) * d;
  *(--Ig1) = x;
  x = *Ig2 + (*g2 + *(g2-1)) * d;
  *(--Ig2) = x;
 }
}
