/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void FLT_NAME(bbox)(FLT *x1, FLT *y1, FLT *x2, FLT *y2, meq_bool *lxy, FLT *x, FLT *y, int nx, int ny) {
 int kx, ky;
 FLT *xp, *yp, xv, yv, xa, xb, ya, yb;
 meq_bool *lp = lxy, init = meq_true;
 for (ky = ny, yp = y; ky--; ) {
  yv = *yp++;
  xp = x;
  for (kx = nx; kx--; ) {
   xv = *xp++;
   if (*lp++) {
    if (init) {
     xa = xb = xv;
     ya = yb = yv;
     init = meq_false;
    } else {
     if      (xv < xa) xa = xv;
     else if (xv > xb) xb = xv;
     if      (yv < ya) ya = yv;
     else if (yv > yb) yb = yv;
    }
   }
  }
 }
 if (init) {
  *x1 = *x2 = *y1 = *y2 = FLTC(0.0);
 } else {
  *x1 = xa; *x2 = xb; *y1 = ya; *y2 = yb;
 }
}
