/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void FLT_NAME(bavx)(meq_bool *l, FLT a,  FLT *rx, FLT *zx, FLT *vrx, FLT *vzx,int nx, FLT *r, FLT *z, int n) {
 FLT *rxp, *zxp, *vrxp, *vzxp, rv, zv, rpx, zpx, vr, vz;
 int kx, k;
 meq_bool ll = meq_false /* in case nx = 0 */;
 if (a == FLTC(0.0))
  for (k=n; k--; ) {
   rv = *r++;
   zv = *z++;
   for (kx=nx, rxp=rx, zxp=zx, vrxp=vrx, vzxp=vzx; kx--; ) {
    if ((ll = (*vrxp++ * (rv - *rxp++) + *vzxp++ * (zv - *zxp++)) < FLTC(0.0))) break;
   }
   *l++ = !ll;
  }
 else
  for (k=n; k--; ) {
   rv = *r++;
   zv = *z++;
   for (kx=nx, rxp=rx, zxp=zx, vrxp=vrx, vzxp=vzx; kx--; ) {
    rpx = rv - *rxp++;
    zpx = zv - *zxp++;
    vr = *vrxp++;
    vz = *vzxp++;
    if ((ll = (vr*rpx + vz*zpx) < a * ABS(vz*rpx - vr*zpx))) break;
   }
   *l++ = !ll;
  }
}

void FLT_NAME(bavx2)(meq_bool *l, FLT a, FLT *rx, FLT *zx, FLT *vrx, FLT *vzx, int nx, FLT *r, FLT *z, int nr, int nz) {
 FLT *rxp, *zxp, *vrxp, *vzxp, *zp, rv, zv, rpx, zpx, vr, vz;
 int kx, kr, kz;
 meq_bool ll = meq_false /* in case nx = 0 */;
 if (a == FLTC(0.0))
  for (kr=nr; kr--;) {
   rv = *r++;
   for (kz=nz, zp=z; kz--; ) {
    zv = *zp++;
    for (kx=nx, rxp=rx, zxp=zx, vrxp=vrx, vzxp=vzx; kx--; ) {
     if ((ll = (*vrxp++ * (rv - *rxp++) + *vzxp++ * (zv - *zxp++)) < FLTC(0.0))) break;
    }
    *l++ = !ll;
   }
  }
 else
  for (kr=nr; kr--;) {
   rv = *r++;
   for (kz=nz, zp=z; kz--; ) {
    zv = *zp++;
    for (kx=nx, rxp=rx, zxp=zx, vrxp=vrx, vzxp=vzx; kx--; ) {
     rpx = rv - *rxp++;
     zpx = zv - *zxp++;
     vr = *vrxp++;
     vz = *vzxp++;
     if ((ll = (vr*rpx + vz*zpx) < a * ABS(vz*rpx - vr*zpx))) break;
    }
    *l++ = !ll;
   }
  }
}
