function opts = ipmopts(varargin)
% IPMOPTS Provides parameters for ipmwrapper routine
%
%   OPTS = IPMOPTS(VARARGIN)
%
% Available parameters:
%   useoptimized
%   niter
%   tol
%   debug
%   presolve
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Defaults
opts.useoptimized = true;
opts.niter = 200;
opts.tol = 1e-12;
opts.debug = false;
opts.presolve = false;

if nargin < 1
  return
end

% Parse optional inputs
p = inputParser;
p.addParameter('useoptimized',opts.useoptimized,@(x) isscalar(x) && islogical(x));
p.addParameter('niter'       ,opts.niter       ,@(x) isscalar(x) && isnumeric(x) && (x == round(x)));
p.addParameter('tol'         ,opts.tol         ,@(x) isscalar(x) && isnumeric(x) && (x > 0));
p.addParameter('debug'       ,opts.debug       ,@(x) isscalar(x) && islogical(x));
p.addParameter('presolve'    ,opts.presolve    ,@(x) isscalar(x) && islogical(x));
p.parse(varargin{:});
opts = p.Results;

end
