%IPMHMEX  Fit FE with Interior Point Method
% [IE,JH,ST] = IPMHMEX(AHD,AED,AHE,AEH,AHH,UH,YD,IE0,JH0,SIP,NIT,TOL)
% solves for IE,JH in a LS sense and imposing SIP*JH>0
%       YR = [WRE WRH]*[IE;JH]
%  YD = YE = [WEE   0]*[IE;JH]
%       YI = [  0 WIH]*[IE;JH]
% by iteratively solving for JH and IE respectively
%  YR-WRE*IE = WRH*JH <=> min JH'*AHH*JH/2+(AHD*YD+AHE*IE)'*JH 
%  YI        = WIH*JH <=> SIP*JH>0
% and
%  YR-WRH*JH = WRE*IE <=> IE=AED*YD+AEH*JH
%  YE        = WEE*IE
% AHD=-[WRH';0;WIH'], AED=[WRE'*WRE+WEE'*WEE]\[WRE',WEE',0], AHE=WRH'*WRE,
% AEH=-[WRE'*WRE+WEE'*WEE]\AHE', AHH=AHE*AEH, UH=TRIU(WRH'*WRH+WIH'*WIH).
% IE0,JH0 are initial guesses. NIT and TOL control the iteration numbers
% and the convergence criterion. ST=1 if success.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [varargout] = ipmhmex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [varargout{1:nargout}] = ipmhmexm(varargin{:});
end
