%IPM4MEX  Interior point method for aX>0 and no equality constraints 
% [X,Z,KT,ST] = IPM4MEX(UH,C,A,XI,ZI,TOL,NIT,VERB) finds X that minimises
% X'*H*X/2+C'*X, A*X>0 with scalar A, UH=H(TRIU(TRUE(SIZE(H)))), using the
% interior point method. XI,ZI are initial guesses. NIT and TOL control the
% iteration numbers and the convergence criterion. If VERB=TRUE progress
% is displayed. STAT=1 if success. KT is the number of iterations performed.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [varargout] = ipm4mex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [varargout{1:nargout}] = ipm4mexm(varargin{:});
end
