/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

/* Generated by mkmeqh.m 31-Jan-2025 14:06:08 */
# include "meqh.h"
#ifdef __cplusplus
extern "C" {
#endif
void sgszr( float *Fx,  float *Fb,  float *Jy,  float *cx,  float *cq,  float *cr,  float *cs,  float ci,  float co,  float *p, int nz, int nr, int ntot,  float dz);
void dgszr(double *Fx, double *Fb, double *Jy, double *cx, double *cq, double *cr, double *cs, double ci, double co, double *p, int nz, int nr, int ntot, double dz);
void snfdb( float *dnf,  float *f, int nx, int ny, int ntot);
void dnfdb(double *dnf, double *f, int nx, int ny, int ntot);
int sasxy( float *xa,  float *ya,  float *fa,  float *dx2fa,  float *dy2fa,  float *dxyfa, int *ixa, int dima, int *na,  float *xs,  float *ys,  float *fs,  float *dx2fs,  float *dy2fs,  float *dxyfs, int *ixs, int dims, int *ns,  float *f,  float fnan,  float *x,  float *y, int dc, int nx, int ny,  float dx,  float dy,  float idx,  float idy, meq_bool *lim, int *ws);
int dasxy(double *xa, double *ya, double *fa, double *dx2fa, double *dy2fa, double *dxyfa, int *ixa, int dima, int *na, double *xs, double *ys, double *fs, double *dx2fs, double *dy2fs, double *dxyfs, int *ixs, int dims, int *ns, double *f, double fnan, double *x, double *y, int dc, int nx, int ny, double dx, double dy, double idx, double idy, meq_bool *lim, int *ws);
void sasxy1( float *f, int i, int j, int nx,  float *xe,  float *ye,  float *fe,  float *a,  float *b,  float *c,  float *d,  float *e,  float *h);
void dasxy1(double *f, int i, int j, int nx, double *xe, double *ye, double *fe, double *a, double *b, double *c, double *d, double *e, double *h);
void sbavx(meq_bool *l,  float a,  float *rx,  float *zx,  float *vrx,  float *vzx,int nx,  float *r,  float *z, int n);
void dbavx(meq_bool *l, double a, double *rx, double *zx, double *vrx, double *vzx,int nx, double *r, double *z, int n);
void sbavx2(meq_bool *l,  float a,  float *rx,  float *zx,  float *vrx,  float *vzx, int nx,  float *r,  float *z, int nr, int nz);
void dbavx2(meq_bool *l, double a, double *rx, double *zx, double *vrx, double *vzx, int nx, double *r, double *z, int nr, int nz);
void sfbnd( float *FB,  float *rB,  float *zB, meq_bool *lB, meq_bool *lX, int *kB,  float *Fl,  float *rl,  float *zl,  float *FX,  float *rX,  float *zX, int nX,  float FN, int nl);
void dfbnd(double *FB, double *rB, double *zB, meq_bool *lB, meq_bool *lX, int *kB, double *Fl, double *rl, double *zl, double *FX, double *rX, double *zX, int nX, double FN, int nl);
void spdom(meq_bool *Opy,  float *Fx,  float FB,  float Ip, meq_bool *OXy, int nzy, int nry);
void dpdom(meq_bool *Opy, double *Fx, double FB, double Ip, meq_bool *OXy, int nzy, int nry);
void sbbox( float *x1,  float *y1,  float *x2,  float *y2, meq_bool *lxy,  float *x,  float *y, int nx, int ny);
void dbbox(double *x1, double *y1, double *x2, double *y2, meq_bool *lxy, double *x, double *y, int nx, int ny);
void siata( float *b,  float *a1, int m1,  float *a2, int m2, int n);
void diata(double *b, double *a1, int m1, double *a2, int m2, int n);
void siata1( float *b,  float *a1, int n1,  float *a2, int n2);
void diata1(double *b, double *a1, int n1, double *a2, int n2);
void siata2( float *b,  float *a1, int n1,  float *a2, int n2);
void diata2(double *b, double *a1, int n1, double *a2, int n2);
void siata3( float *b,  float *a1, int n1,  float *a2, int n2);
void diata3(double *b, double *a1, int n1, double *a2, int n2);
void siata4( float *b,  float *a1, int n1,  float *a2, int n2);
void diata4(double *b, double *a1, int n1, double *a2, int n2);
int siataN( float *b,  float *a1, int n1,  float *a2, int n2, int n);
int diataN(double *b, double *a1, int n1, double *a2, int n2, int n);
void suata( float *b,  float *a, int m, int n);
void duata(double *b, double *a, int m, int n);
void sfl4p( float *fl,  float *drfl,  float *dzfl,  float *f, int *k,  float *c,  float fn, int nl, int nz);
void dfl4p(double *fl, double *drfl, double *dzfl, double *f, int *k, double *c, double fn, int nl, int nz);
void sresp( float *Y,  float*A,  float *B,  float*C,  float *D, int m, int nA, int nB, int nC, int nD);
void dresp(double *Y, double*A, double *B, double*C, double *D, int m, int nA, int nB, int nC, int nD);
void sbfct_fag(void *params,  float *alphapg,  float *alphag,  float FBA);
void dbfct_fag(void *params, double *alphapg, double *alphag, double FBA);
void sbfct_f(void *params,  float *g,  float *Ig,  float FxA,  float FBA);
void dbfct_f(void *params, double *g, double *Ig, double FxA, double FBA);
void sbfct_fA(void *params,  float *g,  float *Ig,  float FBA);
void dbfct_fA(void *params, double *g, double *Ig, double FBA);
void sbfct_dfag(void *params,  float *dalphapg,  float *dalphag,  float FBA);
void dbfct_dfag(void *params, double *dalphapg, double *dalphag, double FBA);
void sbfct_df(void *params,  float * dgdFxA,  float * dgdFBA,  float *dIgdFxA,  float *dIgdFBA,  float FxA,  float FBA);
void dbfct_df(void *params, double * dgdFxA, double * dgdFBA, double *dIgdFxA, double *dIgdFBA, double FxA, double FBA);
void sbfct_dfA(void *params,  float *dgAdFBA,  float *dIgAdFBA,  float FBA);
void dbfct_dfA(void *params, double *dgAdFBA, double *dIgAdFBA, double FBA);
void sbfct0( float *fPg,  float *fTg,  float *TDg, void *params);
void dbfct0(double *fPg, double *fTg, double *TDg, void *params);
void sbfct1( float *Tyg,  float *Tpg,  float *ITpg,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int err, void *params);
void dbfct1(double *Tyg, double *Tpg, double *ITpg, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int err, void *params);
void sbfct2( float *gQg,  float *IgQg,  float *FNQ, int nQ, void *params);
void dbfct2(double *gQg, double *IgQg, double *FNQ, int nQ, void *params);
void sbfct3( float *aPpg,  float *aTTpg,  float *aPg,  float *ahqTg,  float *ag,  float FA,  float FB,  float ids, void *params);
void dbfct3(double *aPpg, double *aTTpg, double *aPg, double *ahqTg, double *ag, double FA, double FB, double ids, void *params);
void sbfct4( float *Tdg,  float *Tgy,  float *Fx,  float FA,  float FB, int8_t *Opy, int nzy, int nry, unsigned int *kd,  float *fd, int nd, void *params);
void dbfct4(double *Tdg, double *Tgy, double *Fx, double FA, double FB, int8_t *Opy, int nzy, int nry, unsigned int *kd, double *fd, int nd, void *params);
void sbfct5( float *gA,  float *IgA,  float FA,  float FB, void *params);
void dbfct5(double *gA, double *IgA, double FA, double FB, void *params);
void sbfct6( float *Qqg,  float *Xq,  float FA,  float FB,  float rA,  float irA,  float ids, int nq, void *params);
void dbfct6(double *Qqg, double *Xq, double FA, double FB, double rA, double irA, double ids, int nq, void *params);
void sbfct7( float *Qcg,  float *Xc,  float FA,  float FB, int nc, void *params);
void dbfct7(double *Qcg, double *Xc, double FA, double FB, int nc, void *params);
void sbfct8( float *Bty,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ag,  float rBt,  float ids,  float *iry, int nzy, int nry, int err, void *params);
void dbfct8(double *Bty, double *Fx, double FA, double FB, int8_t *Opy, double *ag, double rBt, double ids, double *iry, int nzy, int nry, int err, void *params);
void sbfct11( float *dTygdFy,  float *dTygdFA,  float *dTygdFB,  float *dITygdFA,  float *dITygdFB,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int err, void *params);
void dbfct11(double *dTygdFy, double *dTygdFA, double *dTygdFB, double *dITygdFA, double *dITygdFB, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int err, void *params);
void sbfct12( float * dgQgdFN,  float * dgQgdF0,  float * dgQgdF1,  float *dIgQgdFN,  float *dIgQgdF0,  float *dIgQgdF1,  float *FNQ, int nQ, void *params);
void dbfct12(double * dgQgdFN, double * dgQgdF0, double * dgQgdF1, double *dIgQgdFN, double *dIgQgdF0, double *dIgQgdF1, double *FNQ, int nQ, void *params);
void sbfct13( float *daPpgdFA,  float *daTTpgdFA,  float *daPgdFA,  float *dahqTgdFA,  float *daPpgdFB,  float *daTTpgdFB,  float *daPgdFB,  float *dahqTgdFB,  float *ag,  float FA,  float FB,  float ids, void *params);
void dbfct13(double *daPpgdFA, double *daTTpgdFA, double *daPgdFA, double *dahqTgdFA, double *daPpgdFB, double *daTTpgdFB, double *daPgdFB, double *dahqTgdFB, double *ag, double FA, double FB, double ids, void *params);
void sbfct15( float *dgA1,  float *dgA2,  float *dIgA1,  float *dIgA2,  float FA,  float FB, void *params);
void dbfct15(double *dgA1, double *dgA2, double *dIgA1, double *dIgA2, double FA, double FB, void *params);
void sbfct16( float *dQqgdFA,  float *dQqgdFB,  float *dQqgdrA,  float *dQqgdirA,  float FA,  float FB,  float rA,  float irA,  float ids, int nq, void *params);
void dbfct16(double *dQqgdFA, double *dQqgdFB, double *dQqgdrA, double *dQqgdirA, double FA, double FB, double rA, double irA, double ids, int nq, void *params);
void sbfct91( float *g,  float *Ig,  float * F,  float FA,  float FB, int nF, void *params);
void dbfct91(double *g, double *Ig, double * F, double FA, double FB, int nF, void *params);
void sbfct92( float *dgx,  float *dgA,  float *dgB,  float *dIgx,  float *dIgA,  float *dIgB,  float * F,  float FA,  float FB, int nF, void *params);
void dbfct92(double *dgx, double *dgA, double *dgB, double *dIgx, double *dIgA, double *dIgB, double * F, double FA, double FB, int nF, void *params);
void sbf3p_f(void *params,  float g[3],  float Ig[3],  float FxA,  float FBA);
void dbf3p_f(void *params, double g[3], double Ig[3], double FxA, double FBA);
void sbf3p_fN(void *params,  float gN[3],  float IgN[3],  float FN);
void dbf3p_fN(void *params, double gN[3], double IgN[3], double FN);
void sbf3p_fA(void *params,  float g[3],  float Ig[3],  float FBA);
void dbf3p_fA(void *params, double g[3], double Ig[3], double FBA);
void sbf3p_fag(void *params,  float alphapg[3],  float alphag[3],  float FBA);
void dbf3p_fag(void *params, double alphapg[3], double alphag[3], double FBA);
void sbf3p_dfN(void *params,  float dgN[3],  float dIgN[3],  float FN);
void dbf3p_dfN(void *params, double dgN[3], double dIgN[3], double FN);
void sbf3p_df(void *params,  float dgdFxA[3],  float dgdFBA[3],  float dIgdFxA[3],  float dIgdFBA[3],  float FxA,  float FBA);
void dbf3p_df(void *params, double dgdFxA[3], double dgdFBA[3], double dIgdFxA[3], double dIgdFBA[3], double FxA, double FBA);
void sbf3p_dfA(void *params,  float dgAdFBA[3],  float dIgAdFBA[3],  float FBA);
void dbf3p_dfA(void *params, double dgAdFBA[3], double dIgAdFBA[3], double FBA);
void sbf3p_dfag(void *params,  float dalphapg[4],  float dalphag[4],  float FBA);
void dbf3p_dfag(void *params, double dalphapg[4], double dalphag[4], double FBA);
void sbf3p_fPg( float fPg[3],  float fTg[3]);
void dbf3p_fPg(double fPg[3], double fTg[3]);
void sbf3p1( float *Tyg,  float *Tpg,  float *ITpg,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, meq_bool circ, int err);
void dbf3p1(double *Tyg, double *Tpg, double *ITpg, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, meq_bool circ, int err);
void sbf3p2( float *gQg,  float *IgQg,  float *FNQ, int nQ);
void dbf3p2(double *gQg, double *IgQg, double *FNQ, int nQ);
void sbf3p3( float *aPpg,  float *aTTpg,  float *aPg,  float *ahqTg,  float *ag,  float FA,  float FB,  float ids);
void dbf3p3(double *aPpg, double *aTTpg, double *aPg, double *ahqTg, double *ag, double FA, double FB, double ids);
void sbf3p5( float *gA,  float *IgA,  float FA,  float FB, meq_bool circ);
void dbf3p5(double *gA, double *IgA, double FA, double FB, meq_bool circ);
void sbf3p6( float *Qg,  float *Xq,  float FA,  float FB,  float irA,  float ids);
void dbf3p6(double *Qg, double *Xq, double FA, double FB, double irA, double ids);
void sbf3p8( float *Bty,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ag,  float rBt, int err,  float ids,  float *iry, int nzy, int nry);
void dbf3p8(double *Bty, double *Fx, double FA, double FB, int8_t *Opy, double *ag, double rBt, int err, double ids, double *iry, int nzy, int nry);
void sbf3p16( float *dQqgdFA,  float *dQqgdFB,  float *dQqgdrA,  float *dQqgdirA,  float FA,  float FB,  float irA,  float ids);
void dbf3p16(double *dQqgdFA, double *dQqgdFB, double *dQqgdrA, double *dQqgdirA, double FA, double FB, double irA, double ids);
void sbf3i_fN(void *params,  float gN[3],  float IgN[3],  float FN);
void dbf3i_fN(void *params, double gN[3], double IgN[3], double FN);
void sbf3i_fag(void *params,  float alphapg[3],  float alphag[3],  float FBA);
void dbf3i_fag(void *params, double alphapg[3], double alphag[3], double FBA);
void sbf3i_f(void *params,  float g[3],  float Ig[3],  float FxA,  float FBA);
void dbf3i_f(void *params, double g[3], double Ig[3], double FxA, double FBA);
void sbf3i_fA(void *params,  float g[3],  float Ig[3],  float FBA);
void dbf3i_fA(void *params, double g[3], double Ig[3], double FBA);
void sbf3i_dfN(void *params,  float dgN[3],  float dIgN[3],  float FN);
void dbf3i_dfN(void *params, double dgN[3], double dIgN[3], double FN);
void sbf3i_dfag(void *params,  float dalphapg[3],  float dalphag[3],  float FBA);
void dbf3i_dfag(void *params, double dalphapg[3], double dalphag[3], double FBA);
void sbf3i_df(void *params,  float d1g[3],  float d2g[3],  float d1Ig[3],  float d2Ig[3],  float FxA,  float FBA);
void dbf3i_df(void *params, double d1g[3], double d2g[3], double d1Ig[3], double d2Ig[3], double FxA, double FBA);
void sbf3i_dfA(void *params,  float dgA[3],  float dIgA[3],  float FBA);
void dbf3i_dfA(void *params, double dgA[3], double dIgA[3], double FBA);
void sbf3i1( float *Tyg,  float *Tpg,  float *ITpg,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry,  float *gNg,  float *IgNg,  float *fPg,  float *fTg, int err, int nN);
void dbf3i1(double *Tyg, double *Tpg, double *ITpg, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, double *gNg, double *IgNg, double *fPg, double *fTg, int err, int nN);
void sbf3i2( float *gQg,  float *IgQg,  float *FNQ, int nQ,  float *gNg,  float *IgNg, int nN);
void dbf3i2(double *gQg, double *IgQg, double *FNQ, int nQ, double *gNg, double *IgNg, int nN);
void sbf3i3( float *aPpg,  float *aTTpg,  float *aPg,  float *ahqTg,  float *ag,  float FA,  float FB,  float *fPg,  float *fTg,  float ids);
void dbf3i3(double *aPpg, double *aTTpg, double *aPg, double *ahqTg, double *ag, double FA, double FB, double *fPg, double *fTg, double ids);
void sbf3i4( float *Tdg,  float *Tgy,  float *Fx,  float FA,  float FB, int8_t *Opy, int nzy, int nry, unsigned int *kd,  float *fd, int nd,  float *gNg, int nN, int ng);
void dbf3i4(double *Tdg, double *Tgy, double *Fx, double FA, double FB, int8_t *Opy, int nzy, int nry, unsigned int *kd, double *fd, int nd, double *gNg, int nN, int ng);
void sbf3i5( float *gNg,  float *IgNg,  float FA,  float FB, int ng, int nN,  float *gA,  float *IgA);
void dbf3i5(double *gNg, double *IgNg, double FA, double FB, int ng, int nN, double *gA, double *IgA);
void sbf3i6( float *Qg,  float *Xq);
void dbf3i6(double *Qg, double *Xq);
void sbf3i8( float *Bty,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ag,  float rBt,  float ids,  float *iry, int nzy, int nry,  float *gNg,  float *IgNg,  float *fPg,  float *fTg, int err, int nN);
void dbf3i8(double *Bty, double *Fx, double FA, double FB, int8_t *Opy, double *ag, double rBt, double ids, double *iry, int nzy, int nry, double *gNg, double *IgNg, double *fPg, double *fTg, int err, int nN);
void sbf3i11( float *dTygdFy,  float *dTygdFA,  float *dTygdFB,  float *dITygdFA,  float *dITygdFB,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry,  float *gNg,  float *IgNg,  float *fPg,  float *fTg, int err, int nN);
void dbf3i11(double *dTygdFy, double *dTygdFA, double *dTygdFB, double *dITygdFA, double *dITygdFB, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, double *gNg, double *IgNg, double *fPg, double *fTg, int err, int nN);
void sbf3i15( float *dgA1,  float * dgA2,  float *dIgA1,  float *dIgA2,  float FA,  float FB,  float *gNg,  float *IgNg, int nN);
void dbf3i15(double *dgA1, double * dgA2, double *dIgA1, double *dIgA2, double FA, double FB, double *gNg, double *IgNg, int nN);
void sbf3i16( float *dQqgdFA,  float *dQqgdFB,  float *dQqgdrA,  float *dQqgdirA);
void dbf3i16(double *dQqgdFA, double *dQqgdFB, double *dQqgdrA, double *dQqgdirA);
void sbfef_f_( float g[4],  float Ig[4],  float FxA,  float FBA);
void dbfef_f_(double g[4], double Ig[4], double FxA, double FBA);
void sbfef_fN_( float gN[4],  float IgN[4],  float FN);
void dbfef_fN_(double gN[4], double IgN[4], double FN);
void sbfef_fA_( float g[4],  float Ig[4],  float FBA);
void dbfef_fA_(double g[4], double Ig[4], double FBA);
void sbfef_fag_( float alphapg[4],  float alphag[4],  float FBA);
void dbfef_fag_(double alphapg[4], double alphag[4], double FBA);
void sbfef_dfN_( float dgN[4],  float dIgN[4],  float FN);
void dbfef_dfN_(double dgN[4], double dIgN[4], double FN);
void sbfef_df_( float dgdFxA[4],  float dgdFBA[4],  float dIgdFxA[4],  float dIgdFBA[4],  float FxA,  float FBA);
void dbfef_df_(double dgdFxA[4], double dgdFBA[4], double dIgdFxA[4], double dIgdFBA[4], double FxA, double FBA);
void sbfef_dfA_( float dgAdFBA[4],  float dIgAdFBA[4],  float FBA);
void dbfef_dfA_(double dgAdFBA[4], double dIgAdFBA[4], double FBA);
void sbfef_dfag_( float dalphapg[4],  float dalphag[4],  float FBA);
void dbfef_dfag_(double dalphapg[4], double dalphag[4], double FBA);
void sbfef_dispatch(int narray,  float ** arrayin,  float ** arrayout, void *params);
void dbfef_dispatch(int narray, double ** arrayin, double ** arrayout, void *params);
void sbfef_fPg(int nP, int nT,  float fPg[],  float fTg[]);
void dbfef_fPg(int nP, int nT, double fPg[], double fTg[]);
void sbfef_f(void *params,  float g[],  float Ig[],  float FxA,  float FBA);
void dbfef_f(void *params, double g[], double Ig[], double FxA, double FBA);
void sbfef_fN(void *params,  float gN[],  float IgN[],  float FN);
void dbfef_fN(void *params, double gN[], double IgN[], double FN);
void sbfef_fA(void *params,  float g[],  float Ig[],  float FBA);
void dbfef_fA(void *params, double g[], double Ig[], double FBA);
void sbfef_fag(void *params,  float alphapg[],  float alphag[],  float FBA);
void dbfef_fag(void *params, double alphapg[], double alphag[], double FBA);
void sbfef_df(void *params,  float d1g[],  float d2g[],  float d1Ig[],  float d2Ig[],  float FxA,  float FBA);
void dbfef_df(void *params, double d1g[], double d2g[], double d1Ig[], double d2Ig[], double FxA, double FBA);
void sbfef_dfN(void *params,  float dgN[],  float dIgN[],  float FN);
void dbfef_dfN(void *params, double dgN[], double dIgN[], double FN);
void sbfef_dfA(void *params,  float dg[],  float dIg[],  float FBA);
void dbfef_dfA(void *params, double dg[], double dIg[], double FBA);
void sbfef_dfag(void *params,  float dalphapg[],  float dalphag[],  float FBA);
void dbfef_dfag(void *params, double dalphapg[], double dalphag[], double FBA);
void sbfef1( float *Tyg,  float *Tpg,  float *ITpg,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfef1(double *Tyg, double *Tpg, double *ITpg, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfef2( float *gQg,  float *IgQg,  float *FNQ, int nQ, int nP, int nT);
void dbfef2(double *gQg, double *IgQg, double *FNQ, int nQ, int nP, int nT);
void sbfef3( float *aPpg,  float *aTTpg,  float *aPg,  float *ahqTg,  float *ag,  float FA,  float FB,  float ids, int nP, int nT);
void dbfef3(double *aPpg, double *aTTpg, double *aPg, double *ahqTg, double *ag, double FA, double FB, double ids, int nP, int nT);
void sbfef4( float *Tdg,  float *Tgy,  float *Fx,  float FA,  float FB, int8_t *Opy, int nzy, int nry, unsigned int *kd,  float *fd, int nd, int nP, int nT);
void dbfef4(double *Tdg, double *Tgy, double *Fx, double FA, double FB, int8_t *Opy, int nzy, int nry, unsigned int *kd, double *fd, int nd, int nP, int nT);
void sbfef5( float *gA,  float *IgA,  float FA,  float FB, int nP, int nT);
void dbfef5(double *gA, double *IgA, double FA, double FB, int nP, int nT);
void sbfef6( float *Qqg,  float *Xq,  float FA,  float FB,  float rA,  float irA,  float ids, int nP, int nT, int nq);
void dbfef6(double *Qqg, double *Xq, double FA, double FB, double rA, double irA, double ids, int nP, int nT, int nq);
void sbfef8( float *Bty,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ag,  float rBt,  float ids,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfef8(double *Bty, double *Fx, double FA, double FB, int8_t *Opy, double *ag, double rBt, double ids, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfef11( float *dTygdFy,  float *dTygdFA,  float *dTygdFB,  float *dITygdFA,  float *dITygdFB,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfef11(double *dTygdFy, double *dTygdFA, double *dTygdFB, double *dITygdFA, double *dITygdFB, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfef15( float *dgA1,  float * dgA2,  float *dIgA1,  float *dIgA2,  float FA,  float FB, int nP, int nT);
void dbfef15(double *dgA1, double * dgA2, double *dIgA1, double *dIgA2, double FA, double FB, int nP, int nT);
void sbfef16( float *dQqgdFA,  float *dQqgdFB,  float *dQqgdrA,  float *dQqgdirA,  float FA,  float FB,  float rA,  float irA,  float ids, int nP, int nT, int nq);
void dbfef16(double *dQqgdFA, double *dQqgdFB, double *dQqgdrA, double *dQqgdirA, double FA, double FB, double rA, double irA, double ids, int nP, int nT, int nq);
void sbfab_dispatch(int narray,  float ** arrayin,  float ** arrayout, void *params);
void dbfab_dispatch(int narray, double ** arrayin, double ** arrayout, void *params);
void sbfab_fPg(int nP, int nT,  float fPg[],  float fTg[]);
void dbfab_fPg(int nP, int nT, double fPg[], double fTg[]);
void sbfab_f(void *params,  float g[],  float Ig[],  float FxA,  float FBA);
void dbfab_f(void *params, double g[], double Ig[], double FxA, double FBA);
void sbfab_fN(void *params,  float gN[],  float IgN[],  float FN);
void dbfab_fN(void *params, double gN[], double IgN[], double FN);
void sbfab_fA(void *params,  float g[],  float Ig[],  float FBA);
void dbfab_fA(void *params, double g[], double Ig[], double FBA);
void sbfab_fag(void *params,  float alphapg[],  float alphag[],  float FBA);
void dbfab_fag(void *params, double alphapg[], double alphag[], double FBA);
void sbfab_df(void *params,  float d1g[],  float d2g[],  float d1Ig[],  float d2Ig[],  float FxA,  float FBA);
void dbfab_df(void *params, double d1g[], double d2g[], double d1Ig[], double d2Ig[], double FxA, double FBA);
void sbfab_dfN(void *params,  float dgN[],  float dIgN[],  float FN);
void dbfab_dfN(void *params, double dgN[], double dIgN[], double FN);
void sbfab_dfA(void *params,  float dg[],  float dIg[],  float FBA);
void dbfab_dfA(void *params, double dg[], double dIg[], double FBA);
void sbfab_dfag(void *params,  float dalphapg[],  float dalphag[],  float FBA);
void dbfab_dfag(void *params, double dalphapg[], double dalphag[], double FBA);
void sbfab1( float *Tyg,  float *Tpg,  float *ITpg,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfab1(double *Tyg, double *Tpg, double *ITpg, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfab2( float *gQg,  float *IgQg,  float *FNQ, int nQ, int nP, int nT);
void dbfab2(double *gQg, double *IgQg, double *FNQ, int nQ, int nP, int nT);
void sbfab3( float *aPpg,  float *aTTpg,  float *aPg,  float *ahqTg,  float *ag,  float FA,  float FB,  float ids, int nP, int nT);
void dbfab3(double *aPpg, double *aTTpg, double *aPg, double *ahqTg, double *ag, double FA, double FB, double ids, int nP, int nT);
void sbfab4( float *Tdg,  float *Tgy,  float *Fx,  float FA,  float FB, int8_t *Opy, int nzy, int nry, unsigned int *kd,  float *fd, int nd, int nP, int nT);
void dbfab4(double *Tdg, double *Tgy, double *Fx, double FA, double FB, int8_t *Opy, int nzy, int nry, unsigned int *kd, double *fd, int nd, int nP, int nT);
void sbfab5( float *gA,  float *IgA,  float FA,  float FB, int nP, int nT);
void dbfab5(double *gA, double *IgA, double FA, double FB, int nP, int nT);
void sbfab6( float *Qqg,  float *Xq,  float FA,  float FB,  float rA,  float irA,  float ids, int nP, int nT, int nq);
void dbfab6(double *Qqg, double *Xq, double FA, double FB, double rA, double irA, double ids, int nP, int nT, int nq);
void sbfab7( float *Qcg,  float *Xc,  float FA,  float FB, int nP, int nT, int nc);
void dbfab7(double *Qcg, double *Xc, double FA, double FB, int nP, int nT, int nc);
void sbfab8( float *Bty,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ag,  float rBt,  float ids,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfab8(double *Bty, double *Fx, double FA, double FB, int8_t *Opy, double *ag, double rBt, double ids, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfab11( float *dTygdFy,  float *dTygdFA,  float *dTygdFB,  float *dITygdFA,  float *dITygdFB,  float *Fx,  float FA,  float FB, int8_t *Opy,  float *ry,  float *iry, int nzy, int nry, int nP, int nT, int err);
void dbfab11(double *dTygdFy, double *dTygdFA, double *dTygdFB, double *dITygdFA, double *dITygdFB, double *Fx, double FA, double FB, int8_t *Opy, double *ry, double *iry, int nzy, int nry, int nP, int nT, int err);
void sbfab15( float *dgA1,  float * dgA2,  float *dIgA1,  float *dIgA2,  float FA,  float FB, int nP, int nT);
void dbfab15(double *dgA1, double * dgA2, double *dIgA1, double *dIgA2, double FA, double FB, int nP, int nT);
void sbfab16( float *dQqgdFA,  float *dQqgdFB,  float *dQqgdrA,  float *dQqgdirA,  float FA,  float FB,  float rA,  float irA,  float ids, int nP, int nT, int nq);
void dbfab16(double *dQqgdFA, double *dQqgdFB, double *dQqgdrA, double *dQqgdirA, double FA, double FB, double rA, double irA, double ids, int nP, int nT, int nq);
void sbfab17( float *dQcgdFA,  float *dQcgdFB,  float FA,  float FB, int nP, int nT, int nc);
void dbfab17(double *dQcgdFA, double *dQcgdFB, double FA, double FB, int nP, int nT, int nc);
void sbfpr( float *IgNg,  float *gNg, int n);
void dbfpr(double *IgNg, double *gNg, int n);
void sfsgi( float *Q0Q,  float *Q1Q,  float *Q2Q,  float *Q3Q,  float *Q4Q,  float *iqQ,  float *ItQ,  float *LpQ,  float *rbQ,  float *Q5Q,  float *SlQ,  float *M1q,  float *M2q,  float *rq,  float*irq,  float rA,  float FA,  float FB,  float BA, meq_bool lX,  float rB,  float *iTQ,  float idoq, int npq, int noq);
void dfsgi(double *Q0Q, double *Q1Q, double *Q2Q, double *Q3Q, double *Q4Q, double *iqQ, double *ItQ, double *LpQ, double *rbQ, double *Q5Q, double *SlQ, double *M1q, double *M2q, double *rq, double*irq, double rA, double FA, double FB, double BA, meq_bool lX, double rB, double *iTQ, double idoq, int npq, int noq);
void sfsg2( float *VQ,  float *AQ,  float *aq,  float rA,  float *crq,  float doq, int npq, int noq);
void dfsg2(double *VQ, double *AQ, double *aq, double rA, double *crq, double doq, int npq, int noq);
void svizr( float *y1,  float *y2,  float *y3,  float *f, int8_t *O,  float*r,  float *ir,  float rBt,  float dr,  float dz, int nr, int nz);
void dvizr(double *y1, double *y2, double *y3, double *f, int8_t *O, double*r, double *ir, double rBt, double dr, double dz, int nr, int nz);
void scizr( float *y1,  float *f, int8_t *O,  float *Vy,  float ds,  float *FNQ,  float *F0,  float *F1, int nV, int nQ, int nD, int nr, int nz);
void dcizr(double *y1, double *f, int8_t *O, double *Vy, double ds, double *FNQ, double *F0, double *F1, int nV, int nQ, int nD, int nr, int nz);
void sbslv( float *a,  float *b,  float *a1,  float *b1,  float *b0,  float *A,  float *B, int na, int nb, int niter);
void dbslv(double *a, double *b, double *a1, double *b1, double *b0, double *A, double *B, int na, int nb, int niter);
void srtci( float *a,  float *dan,  float *ai,  float *ero,  float *ezo,  float *F,  float *Fp,  float *cdr,  float *cdz, int8_t *Opy,  float *Fo, int8_t Opo,  float dap, int nr, int nz, int np, int no, int io);
void drtci(double *a, double *dan, double *ai, double *ero, double *ezo, double *F, double *Fp, double *cdr, double *cdz, int8_t *Opy, double *Fo, int8_t Opo, double dap, int nr, int nz, int np, int no, int io);
void srtci1( float *y,  float *a,  float *c,  float *x, int np, int no, int io);
void drtci1(double *y, double *a, double *c, double *x, int np, int no, int io);
void sipm2( float *x,  float *s,  float *z, int* kt, meq_bool *stat,  float *h,  float *c,  float *a,  float *b,  float *x0,  float *s0,  float *z0,  float tol, int nit, meq_bool verb,  float *w, int n, int ni);
void dipm2(double *x, double *s, double *z, int* kt, meq_bool *stat, double *h, double *c, double *a, double *b, double *x0, double *s0, double *z0, double tol, int nit, meq_bool verb, double *w, int n, int ni);
void sipm4( float *x,  float *z, int *kt, meq_bool *stat,  float *h,  float *c,  float a,  float *x0,  float *z0,  float tol, int nit, meq_bool verb,  float *w, int n);
void dipm4(double *x, double *z, int *kt, meq_bool *stat, double *h, double *c, double a, double *x0, double *z0, double tol, int nit, meq_bool verb, double *w, int n);
void sipmh( float *Ie,  float *Jh, meq_bool *st,  float *Ahd,  float *Aed,  float *Ahe,  float *Aeh,  float *Ahh,  float *uAhh,  float *Yd,  float *Ie0,  float *Jh0,  float sIp, int nit,  float tol,  float *w, int nh, int ne, int nd);
void dipmh(double *Ie, double *Jh, meq_bool *st, double *Ahd, double *Aed, double *Ahe, double *Aeh, double *Ahh, double *uAhh, double *Yd, double *Ie0, double *Jh0, double sIp, int nit, double tol, double *w, int nh, int ne, int nd);
void sipmj( float *Ie,  float *aj, meq_bool *st,  float *uAjj,  float *Aje,  float *Aej,  float *Ie0,  float *aj0,  float *Ie_,  float *aj_,  float *Qcj,  float *Xc,  float *s,  float *z,  float tol, int iters,  float *w, int nj, int ne, int nc);
void dipmj(double *Ie, double *aj, meq_bool *st, double *uAjj, double *Aje, double *Aej, double *Ie0, double *aj0, double *Ie_, double *aj_, double *Qcj, double *Xc, double *s, double *z, double tol, int iters, double *w, int nj, int ne, int nc);
double swclk(double f, double dummy);
double dwclk(double f, double dummy);
void srefine( float* r1,  float* z1,  float* rq,  float* zq, int noq, int isLCFS,  float rB,  float zB,  float drd,  float dzd);
void drefine(double* r1, double* z1, double* rq, double* zq, int noq, int isLCFS, double rB, double zB, double drd, double dzd);
void sfitcirc( float* xc,  float* yc,  float* rc, int* s,  float x1,  float y1,  float x2,  float y2,  float x3,  float y3);
void dfitcirc(double* xc, double* yc, double* rc, int* s, double x1, double y1, double x2, double y2, double x3, double y3);
void sfind_closest( float* r1,  float* z1,  float* r2,  float* z2,  float* rq,  float* zq, int noq,  float r, float z);
void dfind_closest(double* r1, double* z1, double* r2, double* z2, double* rq, double* zq, int noq, double r,double z);
void sshap( float *rgeom,  float *zgeom,  float *amino,  float *epsil,  float *kappa,  float *delta,  float *deltl,  float *deltu,  float *rrmax,  float *zrmax,  float *rrmin,  float *zrmin,  float *rzmax,  float *zzmax,  float *rzmin,  float *zzmin,  float *rq,  float *zq,  float rB,  float zB, size_t npq, size_t noq);
void dshap(double *rgeom, double *zgeom, double *amino, double *epsil, double *kappa, double *delta, double *deltl, double *deltu, double *rrmax, double *zrmax, double *rrmin, double *zrmin, double *rzmax, double *zzmax, double *rzmin, double *zzmin, double *rq, double *zq, double rB, double zB, size_t npq, size_t noq);
void srefine( float* r1,  float* z1,  float* rq,  float* zq, int noq, int isLCFS,  float rB,  float zB,  float drd,  float dzd);
void drefine(double* r1, double* z1, double* rq, double* zq, int noq, int isLCFS, double rB, double zB, double drd, double dzd);
void sfitcirc( float* xc,  float* yc,  float* rc, int* s,  float x1,  float y1,  float x2,  float y2,  float x3,  float y3);
void dfitcirc(double* xc, double* yc, double* rc, int* s, double x1, double y1, double x2, double y2, double x3, double y3);
void sfind_closest( float* r1, float* z1, float* r2, float* z2, float* rq,  float* zq,int noq, float r, float z);
void dfind_closest(double* r1,double* z1,double* r2,double* z2,double* rq, double* zq,int noq,double r,double z);
void sasgn( float *y,  float *y0,  float *u, int *iu, int ny, int nu);
void dasgn(double *y, double *y0, double *u, int *iu, int ny, int nu);
void slocQ( float *aR,  float *aQ,  float * qQ,  float *qR,  float NF, int nQ, int nO, int nR, int naR);
void dlocQ(double *aR, double *aQ, double * qQ, double *qR, double NF, int nQ, int nO, int nR, int naR);
void sminQ( float *aqmin,  float *qmin,  float * aQ,  float *qQ,  float sq,  float NF, int nQ, int nmin);
void dminQ(double *aqmin, double *qmin, double * aQ, double *qQ, double sq, double NF, int nQ, int nmin);
void sqint( float * Fi,  float * Bri,  float * Bzi,  float * Brri,  float * Brzi,  float * Bzri,  float * Bzzi,  float *rx,  float *zx,  float * Fx,  float *ri,  float *zi,  float *inM, int ni, int nr, int nz, int n, int ntot);
void dqint(double * Fi, double * Bri, double * Bzi, double * Brri, double * Brzi, double * Bzri, double * Bzzi, double *rx, double *zx, double * Fx, double *ri, double *zi, double *inM, int ni, int nr, int nz, int n, int ntot);
void sbint( float * Fi,  float * Fx, int * k,  float * c, int ni, int nz);
void dbint(double * Fi, double * Fx, int * k, double * c, int ni, int nz);
#ifdef __cplusplus
}
#endif
