/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */


/*
 * bfct.h contains the definitions of types used to pass the parameters
 * for each of the basis function sets
 *
 * These definitions closely follow the corresponding definitions of
 * parameters for the MATLAB implementations, so refer to the help section
 * of the corresponding MATLAB files for more details.
 */

/* Define type for bfct parameters */
struct FLT_NAME(bfct_parameters) {
  int ng;
  FLT *fPg;
  FLT *fTg;
  void *fparams;
  void (*f)   (void *params, FLT *g , FLT *Ig , FLT FxA, FLT FBA);
  void (*fN)  (void *params, FLT *gN, FLT *IgN, FLT FN);
  void (*fag) (void *params, FLT *alphapg, FLT *alphag, FLT FBA);
  void (*fA)  (void *params, FLT *gA, FLT *IgA, FLT FBA);
  void (*df)  (void *params, FLT *dgdFxA, FLT *dgdFBA, FLT *dIgdFxA, FLT *dIgdFBA, FLT FxA, FLT FBA);
  void (*dfN) (void *params, FLT *dgN, FLT *dIgN, FLT FN);
  void (*dfag)(void *params, FLT *dalphapg, FLT *dalphag, FLT FBA);
  void (*dfA) (void *params, FLT *dgA, FLT *dIgA, FLT FBA);
};
typedef struct FLT_NAME(bfct_parameters) FLT_NAME(bfct_params);

/* Define type for bf3i parameters */
struct FLT_NAME(bf3i_parameters) {
  FLT * gNg;
  FLT *IgNg;
  int    nN;
};
typedef struct FLT_NAME(bf3i_parameters) FLT_NAME(bf3i_params);

/* Define type for bfef parameters */
struct bfef_parameters {
  int nP;
  int nT;
};
typedef struct bfef_parameters bfef_params;

/* Define type for bfab parameters */
typedef bfef_params bfab_params;

/* Define type for bf3p parameters */
struct bf3p_parameters {
  meq_bool circ;
};
typedef struct bf3p_parameters bf3p_params;

