%GSZRMEX  Solve Poisson equation
% F = GSZRMEX(FB,I,CX,CQ,CR,CS,CI,CO,D) solves the Poisson equation:
% Delta'(F(z,r) = -2*pi*mu0*r*(I/dr/dz). F is the flux [Wb],
% I(z(2:nz-1),r(2,nr-1)) are the filament currents [A] (assumed 0 on grid
% boundary). FB is the boundary condition stored as [F(1:nz,1) F(1,2)
% F(nz,2) ... F(1:nz,nr)]. Shifts the solution by D*dz.
% CX,CQ,CR,CS,CI,CO are obtained by GSZRC. See also GSZRC.
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015] Section 4.1
%              and ﻿[F. Hofmann, Comput. Phys. Commun. 48(2) 1988].
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function Fx = gszrmex(Fb,Iy,cx,cq,cr,cs,ci,co,dz)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 Fx = gszrmexm(Fb,Iy,cx,cq,cr,cs,ci,co,dz);
 
end
