function okflag = writecell(S,filename_input,n,description_text)
% writes a cell to a .m file.
% which can then be read by C = eval(filename_input)
%
% function okflag = writecell(C,filename_input[,n][,description_text])
%
% optional argument n: precision
% optional argument description_text: text added as comment at top of mfile (1 line)
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
%
if nargin<=2 || isempty(n)
  n = 6; % default precision
end
if nargin<=3 || isempty(description_text)
  description_text = sprintf('from writecell with n = %d',n);
end

textlines{1} = cell2str(S,n);
flag = writefile(textlines,filename_input,description_text);
okflag = ~flag;

end

function flag = writefile(textlines,filename_input,description_text)
% write to file
if ~strcmp(filename_input(end-1:end),'.m')
  % append .m if necessary
  fname = sprintf('%s.m',filename_input);
else
  fname = filename_input;
end
if ~exist('description_text') || isempty(description_text)
  description_text = 'from writefile within writecell';
end
%
fid = fopen(fname,'w+'); assert(fid~=-1,'could not open file %s',fname);
[~,filename]=fileparts(filename_input); % get filename from filename_input with path
fprintf(fid,'function S = %s\n',filename);
fprintf(fid,'%% %s\n',description_text);
fprintf(fid,'%%\n');
fprintf(fid,'%% function S = %s\n%%\n',filename);
fprintf(fid,'%% File written automatically using writecell.m\n');
fprintf(fid,'%%\n');
fprintf(fid,'S = ...\n');
for ii=1:(numel(textlines)-1)
  fprintf(fid,'%s\n',textlines{ii});
end
fprintf(fid,'%s;\n',textlines{end}); % last one with suppressing semicolon

% final semicolon
flag = fclose(fid);
end
