classdef writecell_test < genlib_test
  % Test class for writecell
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties (TestParameter)
    % a challenging cell
    C = {...
         {1,2,3,struct('a','b')},...
        };
  end
  
  properties
    tempdir
  end
  
  methods (TestClassSetup)
    function temporary_directory(testCase)
      testCase.tempdir = tempname;
      testCase.assertTrue(mkdir(testCase.tempdir));
      testCase.addTeardown(@() rmdir(testCase.tempdir,'s'));
    end
  end
  
  methods (Test)
    function test_writecell(testCase,C)
      testCase.addTeardown(@() rmpath(testCase.tempdir));
      addpath(testCase.tempdir);
      %% write
      fname = fullfile(testCase.tempdir,'testCell.m');
      testCase.addTeardown(@() delete(fname));
      ok = writecell(C,fname);
      testCase.assertTrue(ok,'error writing cell');
  
      %% read
      testCase.assertTrue(exist(fname,'file')>0,sprintf('%s does not exist',fname));
      Cout = testCell;
  
      %% test that they are equal
      testCase.verifyEqual(C,Cout);
    end
  end
end
