classdef (SharedTestFixtures={genlib_submodule_fixture}) genlib_mexargs_test < genlib_test
% GENLIB_MEXARGS_TEST test class for C MEX-files argument checks
%
% Uses the mexargs_test class to construct the test case and define
% the test methods. Defines the mexfile property with all MEX-file names
% and each corresponding function defining the checks
%
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% begin mexargs_test boilerplate

  properties
    obj
  end

  methods (TestClassSetup)
    function setup_mexargs(testCase,mexfile)
      % Setup paths to mexargs project
      testCase.applyFixture(matlab.unittest.fixtures.PathFixture(testCase.mexargs_path));
      % Initialize mexargs object for the current MEX-file
      S = testCase.([mexfile,'_args']);
      % Initialize mexargs_test object with test methods
      testCase.obj = mexargs_test(S);
    end
  end

  methods (Test)
    function check_default(testCase)
      testCase.obj.check_default(testCase);
    end
    function check_nargin(testCase)
      testCase.obj.check_nargin(testCase);
    end
    function check_arguments(testCase)
      testCase.obj.check_arguments(testCase);
    end
    function check_nargout(testCase)
      testCase.obj.check_nargout(testCase);
    end
  end

%% end   mexargs_test boilerplate

  properties
    mexargs_path = fullfile(fileparts(fileparts(mfilename('fullpath'))),'mexargs');
  end

  properties (ClassSetupParameter)
    mexfile = {
      'bspbasemex',...
      'bspsum_3',...
      'bspsum_4',...
      'bspsum_5',...
      'bspsum_6',...
      'bytesofmex',...
      'cs2devalmex',...
      'ellipfastmex',...
      'greenemmex_5',...
      'greenemmex_6',...
      'iflooriceiliroundmex',...
      'nansmex',...
      'ztrig',...
      };
  end

  methods (Static)
    function S = bspbasemex_args %#ok<*DEFNU>
      S = mexargs('bspbasemex',{'eq',3},{'le',1});
      S.addarg(linspace(-1,2,11),{'type','double'});
      S.addarg(4,{'type','numeric','scalar',[]});
      S.addarg(rand(21,1),{'type','double'});
    end
    
    function S = bspsum_3_args
      S = mexargs('bspsum',{'ge',3,'le',6},{'le',1});
      S.addarg(linspace(0,1,11),{'type','double'});
      S.addarg(rand(3,1),{'type','double'});
      S.addarg(rand(21,1),{'type','double'});
    end

    function S = bspsum_4_args
      S = genlib_mexargs_test.bspsum_3_args;
      S.addarg(0,{'type','numeric','scalar',[]});
    end

    function S= bspsum_5_args
      S = genlib_mexargs_test.bspsum_4_args;
      S.addarg(0,{'type','numeric','scalar',[]});
    end

    function S = bspsum_6_args
      S = genlib_mexargs_test.bspsum_5_args;
      S.addarg(1,{'type','numeric','scalar',[]});
    end
    
    function S = bytesofmex_args
      S = mexargs('bytesofmex',{'eq',1},{'le',1});
      S.addarg(rand(3,1),{});
    end
    
    function S = cs2devalmex_args
      nxk = 11; nyk = 9;
      ncx = nxk-4; ncy = nyk-4;
      np = 4;
      S = mexargs('cs2devalmex',{'eq',6},{'le',10});
      S.addarg(linspace(0,1,nxk),{'type','double'});
      S.addarg(linspace(0,1,nyk),{'type','double'});
      S.addarg(rand(ncx,ncy),{'type','double'});
      S.addarg(rand(np,1),{'type','double'});
      S.addarg(rand(np,1),{'type','double','numel',[]});
      S.addarg([0,1,2],{'type','double'});
    end
    
    function S = ellipfastmex_args
      S = mexargs('ellipfastmex',{'eq',2},{'le',1});
      S.addarg(rand(25,1),{'type','double'});
      S.addarg(1,{'type','numeric','scalar',[]});
    end
    
    function S = greenemmex_5_args
      S = mexargs('greenemmex',{'ge',5,'le',6},{'le',1}); % nargout not well defined
      S.addarg(rand(25,1),{'type','double'});
      S.addarg(rand(25,1),{'type','double','numel',[]});
      S.addarg(rand(12,1),{'type','double'});
      S.addarg(rand(12,1),{'type','double','numel',[]});
      S.addarg(int32(1),{'type','int32'}); % Check of compatibility between size of 5th argument and nargout to be added
    end

    function S = greenemmex_6_args
      S = genlib_mexargs_test.greenemmex_5_args;
      S.addarg(1,{'type','numeric','scalar',[]});
    end
    
    function S = iflooriceiliroundmex_args
      S = mexargs('iflooriceiliroundmex',{'eq',3},{'le',1});
      S.addarg(linspace(0,1,11),{'type','double'});
      S.addarg(rand(4,1),{'type','double'});
      S.addarg(int32(0),{'type','int32','scalar',[]});
    end
    
    function S = nansmex_args
      S = mexargs('nansmex',{'le',1},{'le',1});
      S.addarg(1,{'type','double'});
    end
    
    function S = ztrig_args
      S = mexargs('ztrig',{'eq',3},{'le',1});
      S.addarg(rand(11,1),{'type','double'});
      S.addarg(0.1,{'type','numeric','scalar',[]});
      S.addarg(0.9,{'type','numeric','scalar',[]});
    end
  end
end
