function S = struct2single(S)
% convert all doubles in a structure to singles, 
% except for doubles which can be represented as integers, these are kept
% unchanged.
% Useful for liuqe Simulink which uses single-precision calculations
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

fields=fieldnames(S);
for ifield=1:numel(fields)
  myfield = fields{ifield};
  val = S.(myfield);
  if isstruct(val)
    S.(myfield)=struct2single(val); % recursive call
  elseif isa(val,'double') && any(int32(val(:))~=val(:))
    % convert non-integer values to single
    S.(myfield)=single(val);
  end
end