/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/*
iround

returns the indices of the elements in a look-up table which are the nearest of
given values

void iround(k,T,sizeT,X,sizeX)

int     *k;     indices of the nearest elements in table T for each value of X.
double  *T;     table to lookup, must be non-empty and sorted
int     sizeT;
double  *X;     values to look up, must be sorted
int     sizeX;
*/

void iround(int *k, double *T, int sizeT, double *X, int sizeX)
{
  register int i = 0, j = 0;
  double mid = 0.0;

  /* Algorithm is identical to iceil with T replaced by table of midpoints */
  if (--sizeT) /* We have at least 2 elements and sizeT is now the index of the last element in T */
    mid = 0.5*(T[0]+T[1]);
  while (i<sizeX) {
    if (j==sizeT)
      k[i++] = sizeT; /* Values above last midpoint */
    else if (X[i] <= mid)
      k[i++] = j;
    else if (++j < sizeT) {
      mid = 0.5*(T[j]+T[j+1]); /* Avoid recomputing midpoint for each new x */
    }
  }
}
