/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/*
iceil

returns the indices of the elements in a look-up table which are nearest but
larger than the given values.

void iceil(k,T,sizeT,X,sizeX)

int     *k;     indices of the nearest but larger elements
                in table T for each value of X, -1 for X > T[sizeT-1]
double  *T;     table to look up, must be sorted
int     sizeT;
double  *X;     values to look up, must be sorted 
int     sizeX;
*/

void iceil(int *k, double *T, int sizeT, double *X, int sizeX)
{
  register int i = 0, j = 0;

  /* do the work */
  while (i<sizeX) {
    if (j==sizeT)
      k[i++] = -1; /* Values above T[sizeT-1] */
    else if (X[i] <= T[j])
      k[i++] = j;
    else if (j < sizeT)
      j++;
  }
}
