function H = printmenu(mode)

% PRINTMENU   CRPP print menu
%   PRINTMENU creates a menu entry for CRPP printing control in the current
%   figure and returns its handle.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin == 0
 h = uimenu(gcf,'Label','CRPPrinter');
 uimenu(h,'Label','Preview','Separator','on','CallBack','printmenu preview')

 uimenu(h,'Label','PS_PRINT','CallBack','print -PPS_PRINT','Separator','on')
 plist = sep2mat(getenv('MATLABPRINTERLIST'));
 for k = 1:size(plist,1)
  if findstr(plist(k,:),'PSC')
   uimenu(h,'Label',plist(k,:),'CallBack',['print -dpsc -P' plist(k,:)])
  else
   uimenu(h,'Label',plist(k,:),'CallBack',['print -P' plist(k,:)])
  end
 end
 
 if nargout, H = h; end
 return
end

switch(mode)
 case 'preview'
  oldunits = get(gcf,'units');
  fact = 1;
  [s,w] = vms('show display');
  if findstr(w,'crpppc')
   fact = 4/3;
  end
  set(gcf,'Units',get(gcf,'PaperUnits'),'Position',fact*get(gcf,'PaperPosition'))
  set(gcf,'Units',oldunits)
end
