function S = parameter_struct(A)
% Create a structure with fieldnames containing the array values
%
% Given an array of integer numbers A, produces a structure S with as many
% fields as elements in A, which each field name following the format 'P_%d'
% and each value being an element of A
%
% For example parameter_struct(1:2) produces the following struct object:
%  struct with fields:
%    P_1: 1
%    P_2: 2
%
% This is meant for the creation of parameter arrays in test suites.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
S = cell2struct(num2cell(A),arrayfun(@(x) sprintf('P_%d',x),A,'UniformOutput',false),2);
end
